/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.composite;

import com.university.bookstore.composite.MaterialBundle;
import com.university.bookstore.composite.MaterialComponent;
import com.university.bookstore.composite.MaterialLeaf;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BundleService {
    private final Map<String, MaterialBundle> bundles = new HashMap<String, MaterialBundle>();

    public MaterialBundle createBundle(String name, double discount) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Bundle name cannot be null or empty");
        }
        String bundleName = name.trim();
        if (this.bundles.containsKey(bundleName)) {
            throw new IllegalArgumentException("Bundle already exists: " + bundleName);
        }
        MaterialBundle bundle = new MaterialBundle(bundleName, discount);
        this.bundles.put(bundleName, bundle);
        return bundle;
    }

    public void addToBundle(String bundleName, Material material) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        MaterialBundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle not found: " + bundleName);
        }
        bundle.addComponent(new MaterialLeaf(material));
    }

    public void addBundleToBundle(String parentBundleName, String childBundleName) {
        MaterialBundle parent = this.bundles.get(parentBundleName);
        MaterialBundle child = this.bundles.get(childBundleName);
        if (parent == null) {
            throw new IllegalArgumentException("Parent bundle not found: " + parentBundleName);
        }
        if (child == null) {
            throw new IllegalArgumentException("Child bundle not found: " + childBundleName);
        }
        parent.addComponent(child);
    }

    public void addComponentToBundle(String bundleName, MaterialComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        MaterialBundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle not found: " + bundleName);
        }
        bundle.addComponent(component);
    }

    public boolean removeFromBundle(String bundleName, Material material) {
        MaterialBundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            return false;
        }
        return bundle.removeComponent(new MaterialLeaf(material));
    }

    public Optional<MaterialBundle> getBundle(String name) {
        return Optional.ofNullable(this.bundles.get(name));
    }

    public List<MaterialBundle> getAllBundles() {
        return new ArrayList<MaterialBundle>(this.bundles.values());
    }

    public List<String> getBundleNames() {
        return new ArrayList<String>(this.bundles.keySet());
    }

    public double calculateBundleSavings(String bundleName) {
        MaterialBundle bundle = this.bundles.get(bundleName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle not found: " + bundleName);
        }
        return bundle.getTotalSavings();
    }

    public double calculateTotalSavings() {
        return this.bundles.values().stream().mapToDouble(MaterialBundle::getTotalSavings).sum();
    }

    public double getTotalBundleValue() {
        return this.bundles.values().stream().mapToDouble(MaterialBundle::getPrice).sum();
    }

    public double getTotalDiscountedBundleValue() {
        return this.bundles.values().stream().mapToDouble(MaterialBundle::getDiscountedPrice).sum();
    }

    public List<MaterialBundle> getBundlesByMaterialType(Material.MaterialType type) {
        return this.bundles.values().stream().filter(bundle -> bundle.containsType(type)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<MaterialBundle> getBundlesByDiscount(double minDiscount) {
        return this.bundles.values().stream().filter(bundle -> bundle.getDiscountRate() >= minDiscount).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<MaterialBundle> getBundlesByValueRange(double minValue, double maxValue) {
        return this.bundles.values().stream().filter(bundle -> {
            double value = bundle.getPrice();
            return value >= minValue && value <= maxValue;
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public boolean removeBundle(String name) {
        return this.bundles.remove(name) != null;
    }

    public void clearAllBundles() {
        this.bundles.clear();
    }

    public int getBundleCount() {
        return this.bundles.size();
    }

    public boolean isEmpty() {
        return this.bundles.isEmpty();
    }

    public BundleStats getBundleStats() {
        int totalBundles = this.bundles.size();
        int totalItems = this.bundles.values().stream().mapToInt(MaterialBundle::getItemCount).sum();
        double totalValue = this.getTotalBundleValue();
        double totalDiscountedValue = this.getTotalDiscountedBundleValue();
        double totalSavings = this.calculateTotalSavings();
        double averageDiscount = this.bundles.values().stream().mapToDouble(MaterialBundle::getDiscountRate).average().orElse(0.0);
        return new BundleStats(totalBundles, totalItems, totalValue, totalDiscountedValue, totalSavings, averageDiscount);
    }

    public String toString() {
        return String.format("BundleService[Bundles=%d, TotalValue=$%.2f, TotalSavings=$%.2f]", this.getBundleCount(), this.getTotalBundleValue(), this.calculateTotalSavings());
    }

    public static class BundleStats {
        private final int totalBundles;
        private final int totalItems;
        private final double totalValue;
        private final double totalDiscountedValue;
        private final double totalSavings;
        private final double averageDiscount;

        public BundleStats(int totalBundles, int totalItems, double totalValue, double totalDiscountedValue, double totalSavings, double averageDiscount) {
            this.totalBundles = totalBundles;
            this.totalItems = totalItems;
            this.totalValue = totalValue;
            this.totalDiscountedValue = totalDiscountedValue;
            this.totalSavings = totalSavings;
            this.averageDiscount = averageDiscount;
        }

        public int getTotalBundles() {
            return this.totalBundles;
        }

        public int getTotalItems() {
            return this.totalItems;
        }

        public double getTotalValue() {
            return this.totalValue;
        }

        public double getTotalDiscountedValue() {
            return this.totalDiscountedValue;
        }

        public double getTotalSavings() {
            return this.totalSavings;
        }

        public double getAverageDiscount() {
            return this.averageDiscount;
        }

        public String toString() {
            return String.format("BundleStats[Bundles=%d, Items=%d, Value=$%.2f, Discounted=$%.2f, Savings=$%.2f, AvgDiscount=%.1f%%]", this.totalBundles, this.totalItems, this.totalValue, this.totalDiscountedValue, this.totalSavings, this.averageDiscount * 100.0);
        }
    }
}

