/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.chain.DiscountHandler;
import com.university.bookstore.chain.DiscountRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPHandler
extends DiscountHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPHandler.class);
    private static final double MAX_DISCOUNT = 0.4;

    @Override
    public void handleRequest(DiscountRequest request) {
        if (request.getRequestedDiscount() <= 0.4) {
            request.setApproved(true);
            request.setApprovedBy("VP");
            LOGGER.info("VP approved {}% discount for {}", (Object)request.getRequestedDiscountPercentage(), (Object)request.getMaterial().getTitle());
        } else {
            request.setRejectionReason("Discount too high - exceeds VP approval limit");
            LOGGER.info("VP rejected discount > {}%", (Object)40.0);
        }
    }

    @Override
    public String getHandlerName() {
        return "VPHandler";
    }

    @Override
    public double getMaxDiscount() {
        return 0.4;
    }
}

