/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.chain.DiscountHandler;
import com.university.bookstore.chain.DiscountRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerHandler
extends DiscountHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerHandler.class);
    private static final double MAX_DISCOUNT = 0.15;

    @Override
    public void handleRequest(DiscountRequest request) {
        if (request.getRequestedDiscount() <= 0.15) {
            request.setApproved(true);
            request.setApprovedBy("Manager");
            LOGGER.info("Manager approved {}% discount for {}", (Object)request.getRequestedDiscountPercentage(), (Object)request.getMaterial().getTitle());
        } else {
            LOGGER.info("Manager cannot approve discount > {}%. Passing to Director.", (Object)15.0);
            this.passToNext(request);
        }
    }

    @Override
    public String getHandlerName() {
        return "ManagerHandler";
    }

    @Override
    public double getMaxDiscount() {
        return 0.15;
    }
}

