/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.model.Material;
import java.util.Objects;

public class DiscountRequest {
    private final Material material;
    private final double requestedDiscount;
    private final String customerId;
    private final String reason;
    private boolean approved;
    private String approvedBy;
    private String rejectionReason;
    private final long timestamp;

    public DiscountRequest(Material material, double requestedDiscount, String customerId, String reason) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.requestedDiscount = Math.max(0.0, Math.min(1.0, requestedDiscount));
        this.customerId = Objects.requireNonNull(customerId, "Customer ID cannot be null");
        this.reason = Objects.requireNonNull(reason, "Reason cannot be null");
        this.approved = false;
        this.timestamp = System.currentTimeMillis();
    }

    public Material getMaterial() {
        return this.material;
    }

    public double getRequestedDiscount() {
        return this.requestedDiscount;
    }

    public double getRequestedDiscountPercentage() {
        return this.requestedDiscount * 100.0;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getDiscountedPrice() {
        if (this.approved) {
            return this.material.getPrice() * (1.0 - this.requestedDiscount);
        }
        return this.material.getPrice();
    }

    public double getSavingsAmount() {
        if (this.approved) {
            return this.material.getPrice() * this.requestedDiscount;
        }
        return 0.0;
    }

    public String getSummary() {
        return String.format("Discount Request: %s for %s (%.1f%%) - %s", this.material.getTitle(), this.customerId, this.getRequestedDiscountPercentage(), this.reason);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountRequest that = (DiscountRequest)obj;
        return Double.compare(that.requestedDiscount, this.requestedDiscount) == 0 && this.approved == that.approved && this.timestamp == that.timestamp && Objects.equals(this.material, that.material) && Objects.equals(this.customerId, that.customerId) && Objects.equals(this.reason, that.reason) && Objects.equals(this.approvedBy, that.approvedBy) && Objects.equals(this.rejectionReason, that.rejectionReason);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.requestedDiscount, this.customerId, this.reason, this.approved, this.approvedBy, this.rejectionReason, this.timestamp);
    }

    public String toString() {
        return String.format("DiscountRequest[%s, %.1f%%, %s, %s, Approved=%s]", this.material.getTitle(), this.getRequestedDiscountPercentage(), this.customerId, this.reason, this.approved);
    }
}

