/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.chain.DiscountRequest;

public abstract class DiscountHandler {
    protected DiscountHandler nextHandler;

    public void setNext(DiscountHandler nextHandler) {
        this.nextHandler = nextHandler;
    }

    public DiscountHandler getNext() {
        return this.nextHandler;
    }

    public abstract void handleRequest(DiscountRequest var1);

    protected void passToNext(DiscountRequest request) {
        if (this.nextHandler != null) {
            this.nextHandler.handleRequest(request);
        } else if (!request.isApproved()) {
            request.setRejectionReason("No handler could approve this discount");
        }
    }

    public abstract String getHandlerName();

    public abstract double getMaxDiscount();

    public boolean canApprove(double discount) {
        return discount <= this.getMaxDiscount();
    }

    public int getChainLength() {
        int length = 1;
        for (DiscountHandler current = this.nextHandler; current != null; current = current.getNext()) {
            ++length;
        }
        return length;
    }

    public String getHandlerInfo() {
        return String.format("%s[MaxDiscount=%.1f%%, ChainLength=%d]", this.getHandlerName(), this.getMaxDiscount() * 100.0, this.getChainLength());
    }

    public String toString() {
        return this.getHandlerInfo();
    }
}

