/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.chain.DirectorHandler;
import com.university.bookstore.chain.DiscountHandler;
import com.university.bookstore.chain.DiscountRequest;
import com.university.bookstore.chain.ManagerHandler;
import com.university.bookstore.chain.VPHandler;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscountApprovalService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscountApprovalService.class);
    private final DiscountHandler chain;
    private final List<DiscountRequest> processedRequests;

    public DiscountApprovalService() {
        this.chain = this.buildDefaultChain();
        this.processedRequests = new ArrayList<DiscountRequest>();
    }

    public DiscountApprovalService(DiscountHandler chain) {
        this.chain = Objects.requireNonNull(chain, "Chain cannot be null");
        this.processedRequests = new ArrayList<DiscountRequest>();
    }

    public DiscountRequest requestDiscount(Material material, double discountPercent, String customerId, String reason) {
        if (material == null) {
            throw new IllegalArgumentException("Material cannot be null");
        }
        if (customerId == null || customerId.trim().isEmpty()) {
            throw new IllegalArgumentException("Customer ID cannot be null or empty");
        }
        if (reason == null || reason.trim().isEmpty()) {
            throw new IllegalArgumentException("Reason cannot be null or empty");
        }
        double discountRate = discountPercent / 100.0;
        DiscountRequest request = new DiscountRequest(material, discountRate, customerId, reason);
        LOGGER.info("Processing discount request:");
        LOGGER.info("Material: {}", (Object)material.getTitle());
        LOGGER.info("Requested discount: {}%", (Object)discountPercent);
        LOGGER.info("Customer: {}", (Object)customerId);
        LOGGER.info("Reason: {}", (Object)reason);
        LOGGER.info("---");
        this.chain.handleRequest(request);
        this.processedRequests.add(request);
        if (request.isApproved()) {
            LOGGER.info("// [OK] APPROVED by {}", (Object)request.getApprovedBy());
            LOGGER.info("Final price: ${}", (Object)String.format("%.2f", request.getDiscountedPrice()));
            LOGGER.info("Savings: ${}", (Object)String.format("%.2f", request.getSavingsAmount()));
        } else {
            LOGGER.info("[X] REJECTED: {}", (Object)request.getRejectionReason());
        }
        return request;
    }

    public double calculateFinalPrice(DiscountRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        return request.getDiscountedPrice();
    }

    public List<DiscountRequest> getProcessedRequests() {
        return new ArrayList<DiscountRequest>(this.processedRequests);
    }

    public List<DiscountRequest> getApprovedRequests() {
        return this.processedRequests.stream().filter(DiscountRequest::isApproved).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<DiscountRequest> getRejectedRequests() {
        return this.processedRequests.stream().filter(request -> !request.isApproved()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<DiscountRequest> getRequestsForCustomer(String customerId) {
        return this.processedRequests.stream().filter(request -> Objects.equals(request.getCustomerId(), customerId)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public List<DiscountRequest> getRequestsForMaterial(Material material) {
        return this.processedRequests.stream().filter(request -> Objects.equals(request.getMaterial(), material)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public ApprovalStats getApprovalStats() {
        int totalRequests = this.processedRequests.size();
        int approvedRequests = (int)this.processedRequests.stream().filter(DiscountRequest::isApproved).count();
        int rejectedRequests = totalRequests - approvedRequests;
        double approvalRate = totalRequests > 0 ? (double)approvedRequests / (double)totalRequests : 0.0;
        double totalSavings = this.processedRequests.stream().filter(DiscountRequest::isApproved).mapToDouble(DiscountRequest::getSavingsAmount).sum();
        return new ApprovalStats(totalRequests, approvedRequests, rejectedRequests, approvalRate, totalSavings);
    }

    public void clearRequests() {
        this.processedRequests.clear();
    }

    public String getChainInfo() {
        return this.chain.getHandlerInfo();
    }

    private DiscountHandler buildDefaultChain() {
        ManagerHandler manager = new ManagerHandler();
        DirectorHandler director = new DirectorHandler();
        VPHandler vp = new VPHandler();
        manager.setNext(director);
        director.setNext(vp);
        return manager;
    }

    public String toString() {
        return String.format("DiscountApprovalService[Chain=%s, Requests=%d]", this.chain.getHandlerName(), this.processedRequests.size());
    }

    public static class ApprovalStats {
        private final int totalRequests;
        private final int approvedRequests;
        private final int rejectedRequests;
        private final double approvalRate;
        private final double totalSavings;

        public ApprovalStats(int totalRequests, int approvedRequests, int rejectedRequests, double approvalRate, double totalSavings) {
            this.totalRequests = totalRequests;
            this.approvedRequests = approvedRequests;
            this.rejectedRequests = rejectedRequests;
            this.approvalRate = approvalRate;
            this.totalSavings = totalSavings;
        }

        public int getTotalRequests() {
            return this.totalRequests;
        }

        public int getApprovedRequests() {
            return this.approvedRequests;
        }

        public int getRejectedRequests() {
            return this.rejectedRequests;
        }

        public double getApprovalRate() {
            return this.approvalRate;
        }

        public double getTotalSavings() {
            return this.totalSavings;
        }

        public String toString() {
            return String.format("ApprovalStats[Total=%d, Approved=%d, Rejected=%d, Rate=%.1f%%, Savings=$%.2f]", this.totalRequests, this.approvedRequests, this.rejectedRequests, this.approvalRate * 100.0, this.totalSavings);
        }
    }
}

