/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.chain;

import com.university.bookstore.chain.DiscountHandler;
import com.university.bookstore.chain.DiscountRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorHandler
extends DiscountHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectorHandler.class);
    private static final double MAX_DISCOUNT = 0.25;

    @Override
    public void handleRequest(DiscountRequest request) {
        if (request.getRequestedDiscount() <= 0.25) {
            request.setApproved(true);
            request.setApprovedBy("Director");
            LOGGER.info("Director approved {}% discount for {}", (Object)request.getRequestedDiscountPercentage(), (Object)request.getMaterial().getTitle());
        } else {
            LOGGER.info("Director cannot approve discount > {}%. Passing to VP.", (Object)25.0);
            this.passToNext(request);
        }
    }

    @Override
    public String getHandlerName() {
        return "DirectorHandler";
    }

    @Override
    public double getMaxDiscount() {
        return 0.25;
    }
}

