/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.builder;

import com.university.bookstore.builder.EBookBuilder;
import com.university.bookstore.builder.MaterialBundleBuilder;
import com.university.bookstore.composite.MaterialBundle;
import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import java.util.List;

public class MaterialDirector {
    private final EBookBuilder eBookBuilder;
    private final MaterialBundleBuilder bundleBuilder;

    public MaterialDirector(EBookBuilder eBookBuilder, MaterialBundleBuilder bundleBuilder) {
        this.eBookBuilder = eBookBuilder;
        this.bundleBuilder = bundleBuilder;
    }

    public Material buildPremiumEBook(String id, String title, String author, double price) {
        this.eBookBuilder.reset();
        return this.eBookBuilder.setId(id).setTitle(title).setAuthor(author).setPrice(price).setFileFormat("EPUB").setFileSize(5242880.0).setDrmEnabled(false).setWordCount(50000).setQuality(Media.MediaQuality.HIGH).build();
    }

    public Material buildBasicEBook(String id, String title, String author, double price) {
        this.eBookBuilder.reset();
        return this.eBookBuilder.setId(id).setTitle(title).setAuthor(author).setPrice(price).setFileFormat("PDF").setFileSize(2097152.0).setDrmEnabled(true).setWordCount(30000).setQuality(Media.MediaQuality.MEDIUM).build();
    }

    public Material buildStudentEBook(String id, String title, String author, double price) {
        this.eBookBuilder.reset();
        return this.eBookBuilder.setId(id).setTitle(title).setAuthor(author).setPrice(price).setFileFormat("EPUB").setFileSize(3145728.0).setDrmEnabled(false).setWordCount(40000).setQuality(Media.MediaQuality.HIGH).build();
    }

    public MaterialBundle buildTextbookBundle(String bundleName, List<Material> materials) {
        this.bundleBuilder.reset();
        return this.bundleBuilder.setBundleName(bundleName).setMediumDiscount().addMaterials(materials).build();
    }

    public MaterialBundle buildCourseBundle(String bundleName, List<Material> materials) {
        this.bundleBuilder.reset();
        return this.bundleBuilder.setBundleName(bundleName).setBundleDiscount(0.25).addMaterials(materials).build();
    }

    public MaterialBundle buildPremiumBundle(String bundleName, List<Material> materials) {
        this.bundleBuilder.reset();
        return this.bundleBuilder.setBundleName(bundleName).setLargeDiscount().addMaterials(materials).build();
    }

    public MaterialBundle buildStarterBundle(String bundleName, List<Material> materials) {
        this.bundleBuilder.reset();
        return this.bundleBuilder.setBundleName(bundleName).setSmallDiscount().addMaterials(materials).build();
    }

    public MaterialBundle buildNestedBundle(String bundleName, List<MaterialBundle> bundles, double discount) {
        this.bundleBuilder.reset();
        MaterialBundleBuilder builder = this.bundleBuilder.setBundleName(bundleName).setBundleDiscount(discount);
        for (MaterialBundle bundle : bundles) {
            builder.addBundle(bundle);
        }
        return builder.build();
    }

    public MaterialBundle buildCustomBundle(String bundleName, List<Material> materials, double discount) {
        this.bundleBuilder.reset();
        return this.bundleBuilder.setBundleName(bundleName).setBundleDiscount(discount).addMaterials(materials).build();
    }

    public EBookBuilder getEBookBuilder() {
        return this.eBookBuilder;
    }

    public MaterialBundleBuilder getBundleBuilder() {
        return this.bundleBuilder;
    }

    public EBookBuilder createEBookBuilder() {
        return new EBookBuilder();
    }

    public MaterialBundleBuilder createBundleBuilder() {
        return new MaterialBundleBuilder();
    }
}

