/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.builder;

import com.university.bookstore.builder.ComponentBuilder;
import com.university.bookstore.composite.MaterialBundle;
import com.university.bookstore.composite.MaterialComponent;
import com.university.bookstore.composite.MaterialLeaf;
import com.university.bookstore.model.Material;
import java.util.ArrayList;
import java.util.List;

public class MaterialBundleBuilder
implements ComponentBuilder<MaterialBundle> {
    private String bundleName;
    private double bundleDiscount = 0.0;
    private final List<MaterialComponent> components = new ArrayList<MaterialComponent>();

    public MaterialBundleBuilder setBundleName(String bundleName) {
        this.bundleName = bundleName;
        return this;
    }

    public MaterialBundleBuilder setBundleDiscount(double discount) {
        this.bundleDiscount = Math.max(0.0, Math.min(1.0, discount));
        return this;
    }

    public MaterialBundleBuilder setBundleDiscountPercent(double discountPercent) {
        return this.setBundleDiscount(discountPercent / 100.0);
    }

    public MaterialBundleBuilder addMaterial(Material material) {
        if (material != null) {
            this.components.add(new MaterialLeaf(material));
        }
        return this;
    }

    public MaterialBundleBuilder addBundle(MaterialBundle bundle) {
        if (bundle != null) {
            this.components.add(bundle);
        }
        return this;
    }

    public MaterialBundleBuilder addComponent(MaterialComponent component) {
        if (component != null) {
            this.components.add(component);
        }
        return this;
    }

    public MaterialBundleBuilder addMaterials(List<Material> materials) {
        if (materials != null) {
            for (Material material : materials) {
                this.addMaterial(material);
            }
        }
        return this;
    }

    public MaterialBundleBuilder addComponents(List<MaterialComponent> components) {
        if (components != null) {
            for (MaterialComponent component : components) {
                this.addComponent(component);
            }
        }
        return this;
    }

    public MaterialBundleBuilder removeMaterial(Material material) {
        if (material != null) {
            this.components.removeIf(component -> component instanceof MaterialLeaf && ((MaterialLeaf)component).getMaterial().equals(material));
        }
        return this;
    }

    public MaterialBundleBuilder removeComponent(MaterialComponent component) {
        this.components.remove(component);
        return this;
    }

    public MaterialBundleBuilder clearComponents() {
        this.components.clear();
        return this;
    }

    public MaterialBundleBuilder setSmallDiscount() {
        return this.setBundleDiscount(0.1);
    }

    public MaterialBundleBuilder setMediumDiscount() {
        return this.setBundleDiscount(0.2);
    }

    public MaterialBundleBuilder setLargeDiscount() {
        return this.setBundleDiscount(0.3);
    }

    @Override
    public MaterialBundle build() {
        this.validate();
        MaterialBundle bundle = new MaterialBundle(this.bundleName, this.bundleDiscount);
        for (MaterialComponent component : this.components) {
            bundle.addComponent(component);
        }
        return bundle;
    }

    @Override
    public void validate() {
        if (this.bundleName == null || this.bundleName.trim().isEmpty()) {
            throw new IllegalStateException("Bundle name is required");
        }
        if (this.bundleDiscount < 0.0 || this.bundleDiscount > 1.0) {
            throw new IllegalStateException("Bundle discount must be between 0.0 and 1.0: " + this.bundleDiscount);
        }
    }

    @Override
    public void reset() {
        this.bundleName = null;
        this.bundleDiscount = 0.0;
        this.components.clear();
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public double getBundleDiscount() {
        return this.bundleDiscount;
    }

    public double getBundleDiscountPercent() {
        return this.bundleDiscount * 100.0;
    }

    public List<MaterialComponent> getComponents() {
        return new ArrayList<MaterialComponent>(this.components);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public boolean hasComponents() {
        return !this.components.isEmpty();
    }

    public double getTotalPrice() {
        return this.components.stream().mapToDouble(MaterialComponent::getPrice).sum();
    }

    public double getTotalDiscountedPrice() {
        double totalPrice = this.getTotalPrice();
        return totalPrice * (1.0 - this.bundleDiscount);
    }

    public double getTotalSavings() {
        return this.getTotalPrice() - this.getTotalDiscountedPrice();
    }

    public String toString() {
        return String.format("MaterialBundleBuilder[Name=%s, Discount=%.1f%%, Components=%d, TotalPrice=$%.2f, Savings=$%.2f]", this.bundleName, this.getBundleDiscountPercent(), this.getComponentCount(), this.getTotalPrice(), this.getTotalSavings());
    }
}

