/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.builder;

import com.university.bookstore.builder.MaterialBuilder;
import com.university.bookstore.model.EBook;
import com.university.bookstore.model.Media;

public class EBookBuilder
implements MaterialBuilder<EBook> {
    private String id;
    private String title;
    private String author;
    private double price;
    private int year;
    private String fileFormat;
    private double fileSize;
    private boolean drmEnabled = false;
    private int wordCount;
    private Media.MediaQuality quality = Media.MediaQuality.MEDIUM;

    public EBookBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public EBookBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public EBookBuilder setAuthor(String author) {
        this.author = author;
        return this;
    }

    public EBookBuilder setPrice(double price) {
        this.price = price;
        return this;
    }

    public EBookBuilder setYear(int year) {
        this.year = year;
        return this;
    }

    public EBookBuilder setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public EBookBuilder setFileSize(double fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public EBookBuilder setDrmEnabled(boolean drmEnabled) {
        this.drmEnabled = drmEnabled;
        return this;
    }

    public EBookBuilder setWordCount(int wordCount) {
        this.wordCount = wordCount;
        return this;
    }

    public EBookBuilder setQuality(Media.MediaQuality quality) {
        this.quality = quality;
        return this;
    }

    public EBookBuilder enableDRM() {
        this.drmEnabled = true;
        return this;
    }

    public EBookBuilder disableDRM() {
        this.drmEnabled = false;
        return this;
    }

    public EBookBuilder setHighQuality() {
        this.quality = Media.MediaQuality.HIGH;
        return this;
    }

    public EBookBuilder setLowQuality() {
        this.quality = Media.MediaQuality.LOW;
        return this;
    }

    @Override
    public EBook build() {
        this.validate();
        return new EBook(this.id, this.title, this.author, this.price, this.year, this.fileFormat, this.fileSize, this.drmEnabled, this.wordCount, this.quality);
    }

    @Override
    public void validate() {
        if (this.id == null || this.id.trim().isEmpty()) {
            throw new IllegalStateException("ID is required");
        }
        if (this.title == null || this.title.trim().isEmpty()) {
            throw new IllegalStateException("Title is required");
        }
        if (this.author == null || this.author.trim().isEmpty()) {
            throw new IllegalStateException("Author is required");
        }
        if (this.price < 0.0) {
            throw new IllegalStateException("Price must be non-negative: " + this.price);
        }
        if (this.year < 1000 || this.year > 2100) {
            throw new IllegalStateException("Year must be between 1000 and 2100: " + this.year);
        }
        if (this.fileFormat == null || this.fileFormat.trim().isEmpty()) {
            throw new IllegalStateException("File format is required");
        }
        if (this.fileSize < 0.0) {
            throw new IllegalStateException("File size must be non-negative: " + this.fileSize);
        }
        if (this.wordCount < 0) {
            throw new IllegalStateException("Word count must be non-negative: " + this.wordCount);
        }
        if (this.quality == null) {
            throw new IllegalStateException("Quality is required");
        }
    }

    @Override
    public void reset() {
        this.id = null;
        this.title = null;
        this.author = null;
        this.price = 0.0;
        this.year = 0;
        this.fileFormat = null;
        this.fileSize = 0.0;
        this.drmEnabled = false;
        this.wordCount = 0;
        this.quality = Media.MediaQuality.MEDIUM;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public double getPrice() {
        return this.price;
    }

    public int getYear() {
        return this.year;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public double getFileSize() {
        return this.fileSize;
    }

    public boolean isDrmEnabled() {
        return this.drmEnabled;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public Media.MediaQuality getQuality() {
        return this.quality;
    }

    public String toString() {
        return String.format("EBookBuilder[ID=%s, Title=%s, Author=%s, Price=$%.2f, Year=%d, Format=%s, Size=%.2fMB, DRM=%s, Words=%d, Quality=%s]", new Object[]{this.id, this.title, this.author, this.price, this.year, this.fileFormat, this.fileSize, this.drmEnabled, this.wordCount, this.quality});
    }
}

