/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.api;

import com.university.bookstore.api.MaterialStore;
import com.university.bookstore.model.Material;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface ModernMaterialStore
extends MaterialStore {
    public CompletableFuture<Boolean> addMaterialAsync(Material var1);

    public CompletableFuture<Optional<Material>> findByIdAsync(String var1);

    public CompletableFuture<List<Material>> searchByTitleAsync(String var1);

    public CompletableFuture<ModernInventoryStats> getModernInventoryStatsAsync();

    public CompletableFuture<List<Material>> advancedSearchAsync(SearchCriteria var1);

    public CompletableFuture<BatchOperationResult> addMaterialsBatchAsync(List<Material> var1);

    public CompletableFuture<BatchOperationResult> removeMaterialsBatchAsync(List<String> var1);

    public record SearchCriteria(Optional<String> title, Optional<String> creator, Optional<Material.MaterialType> type, Optional<Double> minPrice, Optional<Double> maxPrice, Optional<Integer> yearFrom, Optional<Integer> yearTo) {
        public static Builder builder() {
            return new Builder();
        }

        public boolean hasAnyCriteria() {
            return this.title.isPresent() || this.creator.isPresent() || this.type.isPresent() || this.minPrice.isPresent() || this.maxPrice.isPresent() || this.yearFrom.isPresent() || this.yearTo.isPresent();
        }

        public static class Builder {
            private Optional<String> title = Optional.empty();
            private Optional<String> creator = Optional.empty();
            private Optional<Material.MaterialType> type = Optional.empty();
            private Optional<Double> minPrice = Optional.empty();
            private Optional<Double> maxPrice = Optional.empty();
            private Optional<Integer> yearFrom = Optional.empty();
            private Optional<Integer> yearTo = Optional.empty();

            public Builder withTitle(String title) {
                this.title = Optional.ofNullable(title);
                return this;
            }

            public Builder withCreator(String creator) {
                this.creator = Optional.ofNullable(creator);
                return this;
            }

            public Builder withType(Material.MaterialType type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            public Builder withPriceRange(Double min, Double max) {
                this.minPrice = Optional.ofNullable(min);
                this.maxPrice = Optional.ofNullable(max);
                return this;
            }

            public Builder withYearRange(Integer from, Integer to) {
                this.yearFrom = Optional.ofNullable(from);
                this.yearTo = Optional.ofNullable(to);
                return this;
            }

            public SearchCriteria build() {
                return new SearchCriteria(this.title, this.creator, this.type, this.minPrice, this.maxPrice, this.yearFrom, this.yearTo);
            }
        }
    }

    public record BatchOperationResult(int successful, int failed, List<String> errors) {
        public boolean isCompleteSuccess() {
            return this.failed == 0 && (this.errors == null || this.errors.isEmpty());
        }

        public int totalOperations() {
            return this.successful + this.failed;
        }

        public double successRate() {
            int total = this.totalOperations();
            return total > 0 ? (double)this.successful * 100.0 / (double)total : 0.0;
        }
    }

    public record ModernInventoryStats(int totalCount, double averagePrice, double medianPrice, int uniqueTypes, int mediaCount, int printCount) {
        public ModernInventoryStats {
            if (totalCount < 0) {
                throw new IllegalArgumentException("Total count cannot be negative");
            }
            if (averagePrice < 0.0) {
                throw new IllegalArgumentException("Average price cannot be negative");
            }
            if (medianPrice < 0.0) {
                throw new IllegalArgumentException("Median price cannot be negative");
            }
            if (uniqueTypes < 0) {
                throw new IllegalArgumentException("Unique types cannot be negative");
            }
            if (mediaCount < 0) {
                throw new IllegalArgumentException("Media count cannot be negative");
            }
            if (printCount < 0) {
                throw new IllegalArgumentException("Print count cannot be negative");
            }
        }

        public static ModernInventoryStats empty() {
            return new ModernInventoryStats(0, 0.0, 0.0, 0, 0, 0);
        }

        public boolean isEmpty() {
            return this.totalCount == 0;
        }

        public double getMediaPercentage() {
            return this.totalCount > 0 ? (double)this.mediaCount * 100.0 / (double)this.totalCount : 0.0;
        }

        public double getPrintPercentage() {
            return this.totalCount > 0 ? (double)this.printCount * 100.0 / (double)this.totalCount : 0.0;
        }

        public String getSummary() {
            return String.format("Inventory Statistics:\n- Total Items: %d\n- Average Price: $%.2f\n- Median Price: $%.2f\n- Unique Types: %d\n- Media Materials: %d (%.1f%%)\n- Print Materials: %d (%.1f%%)\n", this.totalCount, this.averagePrice, this.medianPrice, this.uniqueTypes, this.mediaCount, this.getMediaPercentage(), this.printCount, this.getPrintPercentage());
        }
    }
}

