/*
 * Decompiled with CFR 0.152.
 */
package com.university.bookstore.api;

import com.university.bookstore.model.Material;
import com.university.bookstore.model.Media;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public interface MaterialStore {
    public boolean addMaterial(Material var1);

    public Optional<Material> removeMaterial(String var1);

    public Optional<Material> findById(String var1);

    public List<Material> searchByTitle(String var1);

    public List<Material> searchByCreator(String var1);

    public List<Material> getMaterialsByType(Material.MaterialType var1);

    public List<Media> getMediaMaterials();

    public List<Material> filterMaterials(Predicate<Material> var1);

    public List<Material> findRecentMaterials(int var1);

    public List<Material> findByCreators(String ... var1);

    public List<Material> findWithPredicate(Predicate<Material> var1);

    public List<Material> getSorted(Comparator<Material> var1);

    public List<Material> getMaterialsByPriceRange(double var1, double var3);

    public List<Material> getMaterialsByYear(int var1);

    public List<Material> getAllMaterialsSorted();

    public List<Material> getAllMaterials();

    public double getTotalInventoryValue();

    public double getTotalDiscountedValue();

    public InventoryStats getInventoryStats();

    public void clearInventory();

    public int size();

    public boolean isEmpty();

    public static class InventoryStats {
        private final int totalCount;
        private final double averagePrice;
        private final double medianPrice;
        private final int uniqueTypes;
        private final int mediaCount;
        private final int printCount;

        public InventoryStats(int totalCount, double averagePrice, double medianPrice, int uniqueTypes, int mediaCount, int printCount) {
            this.totalCount = totalCount;
            this.averagePrice = averagePrice;
            this.medianPrice = medianPrice;
            this.uniqueTypes = uniqueTypes;
            this.mediaCount = mediaCount;
            this.printCount = printCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public double getAveragePrice() {
            return this.averagePrice;
        }

        public double getMedianPrice() {
            return this.medianPrice;
        }

        public int getUniqueTypes() {
            return this.uniqueTypes;
        }

        public int getMediaCount() {
            return this.mediaCount;
        }

        public int getPrintCount() {
            return this.printCount;
        }

        public String toString() {
            return String.format("InventoryStats[Total=%d, AvgPrice=$%.2f, MedianPrice=$%.2f, Types=%d, Media=%d, Print=%d]", this.totalCount, this.averagePrice, this.medianPrice, this.uniqueTypes, this.mediaCount, this.printCount);
        }
    }
}

