import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

@SuppressWarnings("serial")
public class GUI extends JFrame{
	BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
	JTextArea write = new JTextArea();
	Compiler c=new Compiler();
	String fileName = null;
	JCheckBox asci = new JCheckBox("asci");
	JCheckBox debug = new JCheckBox("debug");
	JTextField messages = new JTextField();
	public GUI(String string) {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JPanel mainPanel = makeGUI ();
		setContentPane (mainPanel);
		pack();
		setVisible(true);
	}

	public static void main(String[] args) throws IOException{
		@SuppressWarnings("unused")
		GUI gui = new GUI("");
	}

	public JPanel makeGUI() {
		JPanel GUI = new JPanel ();
		GUI.setLayout (new BorderLayout ());
		write.setEditable(true);
		write.setPreferredSize(new Dimension(400, 400));
		GUI.add (write, BorderLayout.CENTER);

		JPanel buttons = new JPanel();
		buttons.setLayout(new GridLayout (1,3));
		JButton save = new JButton ("save");
		save.addActionListener(new saveListener()); 
		buttons.add(save);
		JButton load = new JButton ("load");
		load.addActionListener(new loadListener()); 
		buttons.add(load);
		JButton compile = new JButton ("compile");
		compile.addActionListener(new compileListener()); 
		buttons.add(compile);
		GUI.add(buttons, BorderLayout.SOUTH);

		JPanel conditions = new JPanel();
		conditions.setLayout(new GridLayout (2,1));
		conditions.add(asci);
		conditions.add(debug);
		GUI.add(conditions, BorderLayout.EAST);

		GUI.add(messages, BorderLayout.NORTH);
		return GUI;
	}
	public class saveListener implements ActionListener{
		public void actionPerformed(ActionEvent arg0) {
			messages.setText("enter a file name");
			fileName = messages.getText();
			FileOutputStream fileOutputStream = null;
			try {
				fileOutputStream = new FileOutputStream(fileName+".jj");
			} catch (FileNotFoundException e) {
				messages.setText("file not found");
			}
			PrintStream fps = new PrintStream(fileOutputStream);
			fps.print(write.getText());
			try {
				fileOutputStream.close();
			} catch (IOException e) {
				messages.setText("something went wrong");
			}
		}
	}
	public class loadListener implements ActionListener{
		public void actionPerformed(ActionEvent arg0) {
			try {
				load();
			} catch (IOException e) {
			}
		}
	}
	public class compileListener implements ActionListener{
		public void actionPerformed(ActionEvent arg0) {
			try {
				c.init(fileName,asci.isSelected(),debug.isSelected());
			} catch (IOException e) {
			}
		}
	}
	public void load () throws IOException{
		String text = null;
		BufferedReader fbr = null;
		//messages.setText("enter a file name");
		System.out.println("enter a file name");
		fileName=br.readLine();
		char r=(char)10;
		//fileName = messages.getText();
		try {
			fbr = new BufferedReader(new FileReader(fileName+".jj"));
		} catch (FileNotFoundException e) {
		}
		for (int i=0;i<100;i++){
			if (fbr.readLine()==null)
				break;
			text+=(fbr.readLine());
		}
		write.setText(text);
	}
}
