/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lib.ToolBox;

public class Item
implements Serializable,
Comparable<Item> {
    private String number;
    private String name;
    private double uPrice;
    private int soldQty = 0;
    private double sales = 0.0;
    private int purchasedQty = 0;
    private double purchases = 0.0;
    private static final long serialVersionUID = 1L;

    public Item(String number, String name, double price) {
        this.name = name;
        this.number = number;
        this.uPrice = price;
        ToolBox.crash(name == null, "Item's name cannot be null!");
        ToolBox.crash(number == null, "Item's number cannot be null!");
        ToolBox.crash(price < 0.0, "Item's price cannot be negative");
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getStock() {
        return this.purchasedQty - this.soldQty;
    }

    public double getUnitCost() {
        return this.purchases / (double)this.purchasedQty;
    }

    public boolean setUnitPrice(double price) {
        boolean result = false;
        if (price >= 0.0) {
            this.uPrice = price;
            result = true;
        }
        return result;
    }

    public double getUnitPrice() {
        return this.uPrice;
    }

    public int getSoldQty() {
        return this.soldQty;
    }

    public double getSales() {
        return this.sales;
    }

    public int getPurchasedQty() {
        return this.purchasedQty;
    }

    public double getPurchases() {
        return this.purchases;
    }

    public boolean sell(int qty) {
        return this.sell(qty, (double)qty * this.getUnitPrice());
    }

    public boolean sell(int qty, double amount) {
        if (qty > this.purchasedQty - this.soldQty) {
            return false;
        }
        this.soldQty += qty;
        this.sales += amount;
        return true;
    }

    public void purchase(int qty, double amount) {
        this.purchasedQty += qty;
        this.purchases += amount;
    }

    public String toString() {
        return "Item# " + this.number + " " + this.name;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            result = ((Item)other).getNumber().equals(this.number);
        }
        return result;
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    @Override
    public int compareTo(Item other) {
        return this.toString().compareTo(other.toString());
    }
}

