/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import type.lang.IO;

public class UniReader {
    private String theSource;
    private BufferedReader handle;
    private boolean eofState;
    private String myBuffer;

    public UniReader(String source) {
        try {
            if (source == null) {
                this.handle = new BufferedReader(new InputStreamReader(System.in));
            } else if (source.indexOf("http://") == 0) {
                this.handle = new BufferedReader(new InputStreamReader(new URL(source).openStream()));
            } else {
                if (!new File(source).isAbsolute()) {
                    source = String.valueOf(IO.workingDir) + File.separator + source;
                }
                this.handle = new BufferedReader(new FileReader(source));
            }
            this.theSource = source;
            this.eofState = false;
            this.myBuffer = "";
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File/Path not found!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL!");
        }
        catch (IOException e) {
            throw new RuntimeException("File cannot be opened for reading!");
        }
    }

    public UniReader() {
        this(null);
    }

    public String toString() {
        return "A UniReader connected to: " + this.theSource;
    }

    public boolean eof() {
        return this.eofState;
    }

    public void close() {
        if (this.theSource == null) {
            return;
        }
        try {
            this.handle.close();
        }
        catch (IOException e) {
            throw new RuntimeException("File cannot be closed!");
        }
    }

    public char readChar() {
        char c = '\u0000';
        if (this.myBuffer.length() != 0) {
            c = this.myBuffer.charAt(0);
            this.myBuffer = "";
        } else if (this.eofState) {
            throw new RuntimeException("Reading past end-of-file!");
        }
        try {
            int i = this.handle.read();
            if (i == -1) {
                this.eofState = true;
            } else {
                c = (char)i;
                if (c == '\r') {
                    c = (char)this.handle.read();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Reading error!");
        }
        return c;
    }

    public String readWord() {
        String s;
        char c = this.readChar();
        while (Character.isWhitespace(c) && !this.eofState) {
            c = this.readChar();
        }
        if (this.eofState) {
            s = null;
        } else {
            s = "";
            while (!Character.isWhitespace(c) && !this.eofState) {
                s = String.valueOf(s) + c;
                c = this.readChar();
            }
            if (!this.eofState) {
                this.myBuffer = "" + c;
            }
            this.eofState = false;
        }
        return s;
    }

    public byte readByte() {
        String s = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Byte.valueOf(s);
    }

    public short readShort() {
        String s = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Short.valueOf(s);
    }

    public int readInt() {
        String s = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Integer.valueOf(s);
    }

    public long readLong() {
        String s = this.readWord();
        if (this.eofState) {
            return 0L;
        }
        return Long.valueOf(s);
    }

    public float readFloat() {
        String s = this.readWord();
        if (this.eofState) {
            return 0.0f;
        }
        return Float.valueOf(s).floatValue();
    }

    public double readDouble() {
        String s = this.readWord();
        if (this.eofState) {
            return 0.0;
        }
        return Double.valueOf(s);
    }

    public boolean readBoolean() {
        String s = this.readWord();
        if (this.eofState) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    public String readLine() {
        String s = "";
        char c = this.readChar();
        while (c != '\n' && !this.eofState) {
            s = String.valueOf(s) + c;
            c = this.readChar();
        }
        if (this.eofState) {
            if (s.length() == 0) {
                s = null;
            } else {
                this.eofState = false;
            }
        } else {
            this.myBuffer = "" + c;
        }
        return s;
    }
}

