/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import type.ec.Options;
import type.lang.IO;
import type.lang.UniPanel;
import type.uc.Terminal;

public class UniCon
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final char COPY = '\u00a9';
    JSplitPane jsp;
    JMenuBar menuBar;
    JMenu menu;
    JMenuItem menuItem;
    Container cPane;
    JScrollPane scroll;
    Terminal tv;
    Options option = new Options();
    int fontSize = 18;
    static final String HELP = "  ***************************************************************\n  |  Universal Console is a platform-neutral environment that   |\n  |  streamlines the compilation & execution of Java programs   |\n  |  on any platform. It is written in pure Java and features   |\n  |  a scrollable interactive [term] window that captures and   |\n  |  colour-codes standard in, out, and error.                  |\n  |                                                             |\n  |  - Colour Codes                                             |\n  |    blue=output, red=error, black=input, and green=command   |\n  |                                                             |\n  |   Note that you can use the arrow keys, PgUp/PgDn and/or    |\n  |   the mouse to move around, and you can select/copy text    |\n  |   to the clipboard as usual in your O/S.                    |\n  ***************************************************************\n";
    static final String COMMAND = "  *******************************************************************\n  |  - Commands                                                     |\n  |    > ls       lists contents of working directory (also dir)    |\n  |    > pwd      names the current working directory (also cd)     |\n  |    > cd x     change the working directory to x                 |\n  |    > javac    compiles a java source file (can pass switches)   |\n  |    > java     runs an app (can pass arguments)                  |\n  |    > javadoc  extracts API from a class source file             |\n  |    > java?    runs the JDK tool ?                               |\n  |    > clear    clears the entire console (also cls)              |\n  |    > ENTER    repeats the last-entered command                  |\n  |                                                                 |\n  |  - Keyboard Shortcuts                                           |\n  |    ^P=recompile, ^R=rerun, ^E=re-eCheck, ^I/^D=in/decrease size |\n  |                                                                 |\n  |  - Tools Shortcuts                                              |\n  |    java Options = Tools>Options, java eCheck x = eCheck Checkx  |\n  *******************************************************************\n";
    static final String HOW_DO_I = "  - How do I compile a java program?                            \n    To compile Prog.java issue the (case sensitive) command:    \n    javac Prog.java                                             \n    This assumes that UniCon's working directory is the one in  \n    which the program is stored. If not, use the cd command to  \n    switch to the program's directory.                          \n                                                                \n  - How do I run a java app?                                    \n    To run Prog.class issue the (case sensitive) command:       \n    java Prog                                                   \n                                                                \n  - How do I eCheck an exercise?                                \n    To eCheck exercise 3b (i.e. the file Check03B.java) issue:  \n    java eCheck 3b                                              \n    Alternatively, you can use the Tools menu. Your login data  \n    must be set before you use eCheck for the first time.       \n";
    static String ABOUT = "     UniCon & eCheck (version 7A) \n     Copyright \u00a9 2005-2008 Hamzeh Roumani. All rights reserved.     \n                                                               \n     This software is distributed as accompanying the text:    \n     Java By Abstraction (ISBN 0-321-22689-5). Unauthorized    \n     reproduction or distribution is strictly prohibited.      \n";

    public UniCon() {
        this.setLAF(true, this);
        this.setTitle("Universal Console");
        this.setSize(1000, 600);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UniCon.this.option.setStartup(UniCon.this.tv.pwd);
                System.exit(0);
            }
        });
        this.tv = new Terminal("hamzeh");
        this.tv.setPreferredSize(this.getSize());
        this.tv.pwd = this.option.getStartup();
        this.tv.setBufferSize("9999");
        this.tv.setMargin(new Insets(10, 10, 10, 10));
        this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        this.tv.setBackground(Color.white);
        this.scroll = new JScrollPane(this.tv, 22, 32);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        Hashtable<Object, Action> actions = new Hashtable<Object, Action>();
        Action[] actionsArray = this.tv.getActions();
        int i = 0;
        while (i < actionsArray.length) {
            Action a = actionsArray[i];
            actions.put(a.getValue("Name"), a);
            ++i;
        }
        this.menu = new JMenu("File");
        this.menu.setMnemonic(70);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("Open Directory...", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Show Command Prompt", 80);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Exit", 88);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Edit");
        this.menu.setMnemonic(69);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("Clear Console", 76);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Copy", 67);
        this.menu.add(this.menuItem);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.menuItem.setAction((Action)actions.get("copy-to-clipboard"));
        this.menuItem = new JMenuItem("Select all", 83);
        this.menu.add(this.menuItem);
        this.menuItem.setAction((Action)actions.get("select-all"));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Increase Font Size", 73);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.menuItem = new JMenuItem("Decrease Font Size", 68);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Expand the Graphics Pane", 88);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Collapse the Graphics Pane", 76);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Java L&F", 74);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("O/S L&F", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Tools");
        this.menu.setMnemonic(84);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("eCheck", 69);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("re-Compile", 80);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.menuItem = new JMenuItem("re-Run", 82);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menuItem = new JMenuItem("re-eCheck", 69);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Options", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Help");
        this.menu.setMnemonic(72);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("What is UniCon", 87);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("How do I ...", 72);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Commands", 67);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("About", 65);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.cPane = this.getContentPane();
        this.tv.showCommand(String.valueOf(IO.repeat(255, ' ')) + "\n");
        this.tv.showCommand("Current working directory: " + this.tv.pwd + "\n");
        UniPanel uniPnl = new UniPanel();
        IO.format(uniPnl, "3hamzeh0");
        this.jsp = new JSplitPane(0, true, this.scroll, uniPnl);
        this.jsp.setDividerLocation(0.9);
        this.jsp.setOneTouchExpandable(true);
        this.cPane.add(this.jsp);
        this.setVisible(true);
        this.jsp.setDividerLocation(1.0);
        this.cPane.requestFocusInWindow();
        this.scroll.requestFocusInWindow();
        this.tv.acceptCommand();
        this.tv.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!(evt.getSource() instanceof JMenuItem)) {
            return;
        }
        JMenuItem src = (JMenuItem)evt.getSource();
        if (src.getText().indexOf("xit") != -1) {
            this.option.setStartup(this.tv.pwd);
            System.exit(-1);
        } else if (src.getText().indexOf("eCheck") == 0) {
            String msg = "Enter the number of the exercise to eCheck.\n A checkable exercise number consists of up to two digits followed by a letter.";
            String labNo = JOptionPane.showInputDialog(this, msg, "Exercise Number", 3);
            if (labNo == null) {
                labNo = "";
            }
            if (labNo.length() < 3) {
                labNo = "0" + labNo;
            }
            if (!Options.isValidLabNo(labNo = labNo.toUpperCase())) {
                JOptionPane.showMessageDialog(this, "This is an invalid exercise number!", "Invalid Entry", 0);
            } else {
                this.tv.eCheckAction(labNo);
            }
        } else if (src.getText().indexOf("Increase Font Size") != -1 && this.fontSize < 36) {
            ++this.fontSize;
            this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        } else if (src.getText().indexOf("Decrease Font Size") != -1 && this.fontSize > 8) {
            --this.fontSize;
            this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        } else if (src.getText().indexOf("Options") != -1) {
            this.tv.optionAction(this);
        } else if (src.getText().indexOf("What") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(HELP);
            this.tv.acceptCommand();
        } else if (src.getText().indexOf("How") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(HOW_DO_I);
            this.tv.acceptCommand();
        } else if (src.getText().indexOf("Command") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(COMMAND);
            this.tv.acceptCommand();
        } else if (src.getText().indexOf("About") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(String.valueOf(ABOUT) + "\n" + this.sysInfo() + "\n");
            this.tv.acceptCommand();
        } else if (src.getText().indexOf("Clear") != -1) {
            this.tv.clearAll();
            this.tv.acceptCommand();
        } else if (src.getText().indexOf("Java L&F") != -1) {
            this.setLAF(false, this);
        } else if (src.getText().indexOf("O/S L&F") != -1) {
            this.setLAF(true, this);
        } else if (src.getText().indexOf("Open") != -1) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            fc.setAcceptAllFileFilterUsed(true);
            fc.setDialogTitle("Select the Working Directory");
            int retVal = fc.showDialog(this, "Select");
            if (retVal == 0) {
                int slash;
                String want = fc.getSelectedFile().getPath();
                if (fc.getSelectedFile().isFile() && (slash = want.lastIndexOf(File.separator)) != -1) {
                    want = want.substring(0, slash);
                }
                if (new File(want).exists()) {
                    this.tv.pwd = want;
                }
            }
        } else if (src.getText().indexOf("Expand") != -1) {
            this.jsp.setDividerLocation(0.0);
        } else if (src.getText().indexOf("Collapse") != -1) {
            this.jsp.setDividerLocation(1.0);
        } else if (src.getText().indexOf("re-Compile") != -1) {
            this.tv.exec('C');
        } else if (src.getText().indexOf("re-Run") != -1) {
            this.tv.exec('R');
        } else if (src.getText().indexOf("re-eCheck") != -1) {
            this.tv.exec('E');
        } else if (src.getText().indexOf("Command Prompt") != -1) {
            this.tv.acceptCommand();
        }
    }

    public void setLAF(boolean sysLAF, JFrame frm) {
        String className = UIManager.getCrossPlatformLookAndFeelClassName();
        if (sysLAF) {
            className = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(frm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String sysInfo() {
        return "     - System Info\n       O/S: " + System.getProperty("os.name") + " version: " + System.getProperty("os.version") + "\n" + "       JDK: " + System.getProperty("java.vendor") + " version: " + System.getProperty("java.version") + "\n" + "       Java Directory: " + System.getProperty("java.home") + "\n" + "       Class Path: " + System.getProperty("java.class.path") + "\n\n" + "     - UniCon Info:\n" + "       Launched from: " + System.getProperty("user.dir") + "\n" + "       Version: " + "7A" + ", Options file: " + System.getProperty("user.home") + "/.UCrc\n" + "       Working Directory: " + this.tv.pwd;
    }

    public static void main(String[] args) {
        UniCon f = new UniCon();
        f.setVisible(true);
    }
}

