/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lib.ToolBox;

public class FractionNS
implements Serializable,
Comparable<FractionNS> {
    private long numer;
    private long denom;
    public char separator;
    public static boolean isQuoted = true;
    protected static Random rng = new Random();
    private static final long serialVersionUID = 1L;

    public FractionNS() {
        this(0L, 1L);
    }

    public FractionNS(long numerator, long denominator) {
        this(numerator, denominator, '/');
    }

    public FractionNS(FractionNS fraction) {
        this(fraction.getNumerator(), fraction.getDenominator(), fraction.getSeparator());
    }

    public FractionNS(long numerator, long denominator, char separator) {
        IO.format("Fraction", "1hamzeh0");
        this.setState(numerator, denominator, separator);
    }

    public void add(FractionNS other) {
        if (this.denom == 0L || other.getDenominator() == 0L) {
            this.numer = this.numer * other.getDenominator() + other.getNumerator() * this.denom;
            this.denom *= other.getDenominator();
        } else {
            long common = FractionNS.lcm(this.denom, other.getDenominator());
            this.numer = this.numer * (common / this.denom) + other.getNumerator() * (common / other.getDenominator());
            this.denom = common;
            this.reduce();
        }
    }

    public void subtract(FractionNS other) {
        FractionNS tmp = new FractionNS(-other.getNumerator(), other.getDenominator());
        this.add(tmp);
    }

    public void multiply(FractionNS other) {
        this.numer *= other.numer;
        this.denom *= other.denom;
        this.reduce();
    }

    public void divide(FractionNS other) {
        FractionNS tmp = new FractionNS(other.denom, other.numer);
        this.multiply(tmp);
    }

    public void pow(int exponent) {
        ToolBox.crash(exponent < 0, "A negative exponent!");
        if (exponent > 1) {
            boolean even = exponent / 2 * 2 == exponent;
            FractionNS org = new FractionNS(this.getNumerator(), this.getDenominator());
            this.pow(exponent / 2);
            FractionNS half = new FractionNS(this.getNumerator(), this.getDenominator());
            this.multiply(half);
            if (!even) {
                this.multiply(org);
            }
        } else if (exponent == 0) {
            this.numer = 1L;
            this.denom = 1L;
        }
    }

    public void setNumerator(long numerator) {
        this.setState(numerator, this.denom, this.getSeparator());
    }

    public long getNumerator() {
        return this.numer;
    }

    public void setDenominator(long denominator) {
        this.setState(this.numer, denominator, this.getSeparator());
    }

    public long getDenominator() {
        return this.denom;
    }

    public void setFraction(long numerator, long denominator) {
        this.setState(numerator, denominator, this.getSeparator());
    }

    public void setFraction(FractionNS other) {
        this.setState(other.numer, other.denom, other.getSeparator());
    }

    public boolean setSeparator(char newSeparator) {
        if (Character.isLetterOrDigit(newSeparator)) {
            return false;
        }
        this.separator = newSeparator;
        return true;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String toProperString() {
        String quote = "";
        if (isQuoted) {
            quote = "\"";
        }
        if (this.denom == 0L) {
            return "NaF";
        }
        if (Math.abs(this.numer) < this.denom) {
            return String.valueOf(quote) + this.numer + "/" + this.denom + quote;
        }
        long whole = this.numer / this.denom;
        return String.valueOf(quote) + whole + " " + this.numer % this.denom + "/" + this.denom + quote;
    }

    public boolean resembles(FractionNS other) {
        if (other == null) {
            return false;
        }
        return this.getDenominator() == other.getDenominator();
    }

    public static FractionNS getRandom() {
        return new FractionNS(rng.nextInt(1000), 1 + rng.nextInt(1000));
    }

    public static void setSeed(long seed) {
        rng.setSeed(seed);
    }

    public FractionNS cloneMe() {
        FractionNS copy = new FractionNS(this.numer, this.denom);
        copy.setSeparator(this.getSeparator());
        return copy;
    }

    @Override
    public int compareTo(FractionNS other) {
        FractionNS otherF = other;
        if (this.denom == 0L) {
            if (otherF.denom == 0L) {
                return 0;
            }
            return 1;
        }
        if (otherF.denom == 0L) {
            if (this.denom == 0L) {
                return 0;
            }
            return -1;
        }
        long diff = this.numer * otherF.denom - this.denom * otherF.numer;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    private void setState(long numerator, long denominator, char separator) {
        this.separator = separator;
        if (denominator < 0L) {
            this.numer = -numerator;
            this.denom = -denominator;
        } else {
            this.numer = numerator;
            this.denom = denominator;
        }
        ToolBox.crash(this.denom < 0L, "Internal Error in setState: " + this.denom);
        this.reduce();
    }

    private void reduce() {
        long a = this.getNumerator();
        long b = this.getDenominator();
        if (a == 0L || b == 0L) {
            return;
        }
        long gcd = FractionNS.euc(a, b);
        this.numer /= gcd;
        this.denom /= gcd;
    }

    private static long lcm(long a, long b) {
        return a * b / FractionNS.euc(a, b);
    }

    private static long euc(long a, long b) {
        if (a == 0L || b == 0L) {
            return 1L;
        }
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a < b) {
            long tmp = b;
            b = a;
            a = tmp;
        }
        long c = a % b;
        while (c != 0L) {
            a = b;
            b = c;
            c = a % b;
        }
        return b;
    }
}

