/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Date;
import type.lang.IO;
import type.lang.UniReader;
import type.lib.ToolBox;

public class Stock
implements Serializable {
    private String ticker = null;
    private double price = 0.0;
    private static final double TPi = Math.PI * 2;
    private static final int MAX = 675;
    private static final long YEAR = 31536000L;
    private static final String[] PA = new String[]{"ALPHA", "BRAVO", "CHARLIE", "DELTA", "ECHO", "FOXTROT", "GOLF", "HOTEL", "INDIA", "JULIET", "KILO", "LIMA", "MIKE", "NOVEMBER", "OSCAR", "PAPA", "QUEBEC", "ROMEO", "SIERRA", "TANGO", "UNIFORM", "VICTOR", "WHISKEY", "X-RAY", "YANKEE", "ZULU"};
    public String name = null;
    public char delimiter = (char)32;
    public static boolean titleCaseName = false;
    private static final String TSE_URL = "http://www.google.ca/finance?q=";
    private static final String NAME_KEYWORD = "\"g-unit g-first\"><h3>";
    private static final String PRICE_KEYWORD = "\"pr\">";
    private static final String NOT_FOUND_KEYWORD = "produced no matches";
    private static final long serialVersionUID = 1L;

    public Stock() {
        IO.format("Stock", "1hamzeh0");
        this.setSymbol(null);
    }

    public Stock(String symbol) {
        IO.format("Stock", "1hamzeh0");
        this.setSymbol(symbol);
    }

    public Stock(Stock stock) {
        ToolBox.crash(stock == null, "Cannot copy a null stock!");
        IO.format("Stock", "1hamzeh0");
        this.ticker = stock.ticker;
        this.price = stock.price;
        this.name = stock.name;
        this.delimiter = stock.delimiter;
    }

    public String getName() {
        if (this.name != null & titleCaseName) {
            String ret = "";
            int i = this.name.length() - 1;
            while (i > 0) {
                char c = this.name.charAt(i);
                if (Character.isLetter(c) && Character.isLetter(this.name.charAt(i - 1))) {
                    c = Character.toLowerCase(c);
                }
                ret = String.valueOf(c) + ret;
                --i;
            }
            return String.valueOf(this.name.charAt(0)) + ret;
        }
        return this.name;
    }

    public String getSymbol() {
        return this.ticker;
    }

    public double getPrice() {
        return this.price;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean setDelimiter(char myDelimiter) {
        if (Character.isLetterOrDigit(myDelimiter)) {
            return false;
        }
        this.delimiter = myDelimiter;
        return true;
    }

    public void setSymbol(String symbol) {
        this.ticker = symbol;
        if (this.ticker != null) {
            this.ticker = this.ticker.toUpperCase();
        }
        this.refresh();
    }

    public String toString() {
        if (this.name == null) {
            return "No such stock!";
        }
        return String.valueOf(this.ticker) + this.delimiter + this.name;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            Stock sother = (Stock)other;
            result = this.getSymbol().equals(sother.getSymbol());
        }
        return result;
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }

    public void refresh() {
        this.name = null;
        this.price = 0.0;
        if (this.ticker == null) {
            return;
        }
        if (this.ticker.indexOf("HR.") == 0) {
            this.fake();
            return;
        }
        if (this.ticker.indexOf(".") == 0) {
            this.simulate();
            return;
        }
        UniReader bfr = new UniReader(TSE_URL + this.ticker);
        boolean priceFound = false;
        String rec = bfr.readLine();
        while (!bfr.eof()) {
            int close;
            int open;
            int start;
            int fini;
            int foundAt = rec.indexOf(NAME_KEYWORD);
            if (foundAt != -1 && this.name == null && (fini = rec.indexOf("&", start = foundAt + NAME_KEYWORD.length())) != -1) {
                this.name = rec.substring(start, fini).trim();
            }
            if (rec.indexOf(PRICE_KEYWORD) != -1) {
                priceFound = true;
            }
            if (priceFound && (open = (rec = bfr.readLine()).indexOf(">")) < (close = rec.indexOf("<", open + 1))) {
                this.price = Double.parseDouble(rec.substring(open + 1, close));
                break;
            }
            if (rec.indexOf(NOT_FOUND_KEYWORD) != -1) {
                this.price = 0.0;
                break;
            }
            rec = bfr.readLine();
        }
        bfr.close();
    }

    public Stock cloneMe() {
        Stock copy = new Stock();
        copy.ticker = this.ticker;
        copy.price = this.price;
        copy.name = this.name;
        copy.delimiter = this.delimiter;
        return copy;
    }

    private void fake() {
        String ltr = this.ticker.substring(3, 4);
        int ofst = ltr.compareTo("A") + 1;
        this.name = ofst % 2 == 0 ? String.valueOf(ltr) + "TECH INC." : String.valueOf(ltr) + "COMP CORP";
        this.price = (double)ofst + (double)ofst / 100.0;
        if (ofst < 1 || ofst > 26) {
            this.name = null;
            this.price = 0.0;
        }
    }

    private void simulate() {
        int letter2;
        this.name = null;
        this.price = 0.0;
        if (this.ticker.length() != 3) {
            return;
        }
        if (!this.ticker.matches("\\.[a-z[A-Z]]{2}")) {
            return;
        }
        int letter1 = this.ticker.toUpperCase().charAt(1) - 65;
        int index = 26 * letter1 + (letter2 = this.ticker.toUpperCase().charAt(2) - 65);
        if (index < 0 || index > 675) {
            return;
        }
        Date dt = new Date();
        long time = dt.getTime() / 1000L;
        double base = ((double)index - 337.5) / 337.5;
        base = 100.0 * base * base;
        double phase = Math.PI * 2 * (double)index / 675.0;
        double slowRise = (double)(time -= 1072224000L) / 3.1536E7;
        double quickOsc = 0.05 * Math.sin(Math.PI * 2 * (double)time / 60.0);
        double slowRate = Math.sin(Math.PI * 2 * (double)time / 3.1536E7 + phase);
        this.price = (1.0 + slowRate) * base + quickOsc + slowRise;
        this.price = Double.parseDouble(IO.format(this.price, ".2"));
        int grp = index % 6;
        this.name = grp == 0 ? "The " + PA[letter1] + " " + PA[letter2] + " Corporation" : (grp == 1 ? String.valueOf(PA[letter1]) + " of " + PA[letter2] + " Company" : (grp == 2 ? String.valueOf(PA[letter1]) + "-Tech and " + PA[letter2] + " Co." : (grp == 3 ? String.valueOf(PA[letter1]) + " " + PA[letter2] + " Ltd." : (grp == 4 ? String.valueOf(PA[letter1]) + "-" + PA[letter2] + " Inc." : "Compu-" + PA[letter1] + " & " + PA[letter2] + " Corp."))));
    }
}

