/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.Fraction;
import type.lib.ToolBox;

public class MixedNumber
extends Fraction {
    private static final long serialVersionUID = 1L;

    public MixedNumber() {
        this(1, 0L, 0L, 1L);
    }

    public MixedNumber(MixedNumber mixed) {
        this(mixed.getSign(), mixed.getWhole(), mixed.getNumerator(), mixed.getDenominator());
    }

    public MixedNumber(int s, long w, long n, long d) {
        super((long)s * (n + w * d), d);
        ToolBox.crash(Math.abs(s) != 1, "Sign must be + or -1");
        ToolBox.crash(w < 0L, "Whole part must be non-negative!");
        ToolBox.crash(n < 0L, "Numerator must be non-negative!");
        ToolBox.crash(d < 0L, "Denominator must be non-negative!");
        IO.format("MixedNumber", "1hamzeh0");
    }

    public int getSign() {
        if (super.getNumerator() < 0L) {
            return -1;
        }
        return 1;
    }

    public long getWhole() {
        return Math.abs(super.getNumerator()) / this.getDenominator();
    }

    public long getProperNumerator() {
        return Math.abs(super.getNumerator()) % this.getDenominator();
    }

    public long getProperDenominator() {
        return super.getDenominator();
    }

    @Override
    public String toString() {
        if (this.getProperDenominator() == 0L) {
            return "NaMN";
        }
        String s = "+";
        if (this.getSign() == -1) {
            s = "-";
        }
        return String.valueOf(s) + " " + this.getWhole() + " " + this.getProperNumerator() + "/" + this.getProperDenominator();
    }

    public boolean resembles(MixedNumber other) {
        if (other == null) {
            return false;
        }
        return this.getWhole() == other.getWhole();
    }

    public static Fraction getRandom() {
        if (rng.nextInt(2) == 0) {
            return new MixedNumber(1 - 2 * rng.nextInt(2), rng.nextInt(1000), rng.nextInt(1000), 1 + rng.nextInt(1000));
        }
        return Fraction.getRandom();
    }
}

