/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import type.lang.IO;
import type.lib.ToolBox;

public class CreditCard
implements Serializable {
    public static final double DEFAULT_LIMIT = 1000.0;
    public static final int MIN_NAME_LENGTH = 3;
    public static final int SEQUENCE_NUMBER_LENGTH = 6;
    public static final int MOD = 9;
    private String number;
    private String name;
    private double limit;
    private double balance;
    private Date issueDate;
    private Date expiryDate;
    private static final long serialVersionUID = 1L;

    public CreditCard(int no, String aName, double aLimit, Date issue) {
        ToolBox.crash(aName == null || aName.length() < 3, "Invalid Name");
        ToolBox.crash(aLimit <= 0.0, "Limit must be positive");
        ToolBox.crash(no <= 0 || no > 999999, "Number not in range!");
        this.name = aName;
        this.limit = aLimit;
        this.balance = 0.0;
        this.setCardNo(no);
        GregorianCalendar gc = new GregorianCalendar();
        this.issueDate = new Date(issue.getTime());
        gc.add(1, 2);
        this.expiryDate = gc.getTime();
        IO.format("CreditCard", "1hamzeh0");
    }

    public CreditCard(int no, String aName, double aLimit) {
        this(no, aName, aLimit, new Date());
    }

    public CreditCard(int no, String aName) {
        this(no, aName, 1000.0);
    }

    public double getBalance() {
        return this.balance;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public double getLimit() {
        return this.limit;
    }

    public Date getIssueDate() {
        return new Date(this.issueDate.getTime());
    }

    public Date getExpiryDate() {
        return new Date(this.expiryDate.getTime());
    }

    public boolean setLimit(double newLimit) {
        boolean tmp = false;
        if (newLimit >= 0.0 && newLimit > this.balance) {
            this.limit = newLimit;
            tmp = true;
        }
        return tmp;
    }

    public boolean setExpiryDate(Date expiry) {
        if (expiry != null && expiry.after(this.issueDate)) {
            this.expiryDate = new Date(expiry.getTime());
            return true;
        }
        return false;
    }

    public void credit(double amount) {
        ToolBox.crash(amount < 0.0, "Credit must be non-negative");
        this.balance -= amount;
    }

    public boolean charge(double amount) {
        if (new Date().after(this.expiryDate)) {
            return false;
        }
        ToolBox.crash(amount < 0.0, "Charge must be non-negative");
        if (this.balance + amount <= this.limit) {
            this.balance += amount;
            return true;
        }
        return false;
    }

    public void pay(double amount) {
        ToolBox.crash(amount < 0.0, "Payment must be non-negative");
        this.balance -= amount;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            CreditCard otherC = (CreditCard)other;
            result = this.number.equals(otherC.number);
        }
        return result;
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean isSimilar(CreditCard other) {
        if (other == null) {
            return false;
        }
        return Math.abs(this.getBalance() - other.getBalance()) < 0.01;
    }

    public String toString() {
        return "CARD [NO=" + this.number + ", BALANCE=" + IO.format(this.balance, ".2") + "]";
    }

    private void setCardNo(int no) {
        int sum = CreditCard.digitSum(no);
        int extra = 9 - sum % 9;
        if (extra == 9) {
            extra = 0;
        }
        this.number = String.valueOf(IO.format(no, "Z6")) + "-" + extra;
    }

    private static int digitSum(int x) {
        String tmp = "" + Math.abs(x);
        int sum = 0;
        int i = 0;
        while (i < tmp.length()) {
            sum += Integer.parseInt(tmp.substring(i, i + 1));
            ++i;
        }
        return sum;
    }
}

