/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import type.ec.Options;
import type.lang.IO;
import type.lang.UniReader;
import type.lang.UniWriter;
import type.uc.TermCompile;
import type.uc.TermDoc;
import type.uc.TermErrStream;
import type.uc.TermInpStream;
import type.uc.TermOutStream;
import type.uc.TermRun;
import type.uc.eCheckThread;

public class Terminal
extends JTextPane {
    public String pwd;
    String entry;
    String lastCommand;
    TermRun runThread;
    TermOutStream tos;
    TermInpStream tis;
    TermErrStream tes;
    private TermDoc doc = (TermDoc)this.getDocument();
    private String lastCompile = null;
    private String lastRun = null;
    private String lasteCheck = null;
    private static final long serialVersionUID = 1L;

    public Terminal(String psw) {
        super(new TermDoc());
        if (!psw.equals("hamzeh")) {
            System.exit(-1);
        }
        this.setCaretColor(Color.blue);
        this.doc.setTerminal(this);
        this.lastCommand = null;
        this.entry = null;
        this.tis = new TermInpStream(this);
        this.tos = new TermOutStream(this);
        this.tes = new TermErrStream(this);
        System.setIn(this.tis);
        System.setOut(new PrintStream(this.tos, true));
        System.setErr(new PrintStream(this.tes, true));
        IO.in = new UniReader();
        IO.out = new UniWriter();
    }

    public void setBufferSize(String size) {
        try {
            this.tos.setBufferSize(Long.parseLong(size));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void showOutput(String s) {
        this.doc.print(s, 2);
        Thread.yield();
    }

    public void showCommand(String s) {
        this.doc.print(s, 3);
    }

    public void showError(String s) {
        this.doc.print(s, 4);
        Thread.yield();
    }

    public void showErrorStream(Exception e) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        e.printStackTrace(pw);
        pw.flush();
        this.doc.print(((Object)os).toString(), 4);
    }

    public String read() {
        this.requestFocusInWindow();
        this.doc.setMode(1);
        this.entry = null;
        while (this.entry == null) {
            Thread.yield();
        }
        String tmp = this.entry;
        this.entry = null;
        return tmp;
    }

    public void acceptCommand() {
        this.entry = "";
        this.doc.print("> ", 3);
        this.doc.setMode(0);
    }

    public void exec() {
        if (this.entry.trim().length() == 0 && this.lastCommand != null) {
            this.entry = this.lastCommand;
            this.showCommand("> " + this.entry + "\n");
        } else {
            this.lastCommand = this.entry.trim();
        }
        if (this.entry.indexOf("java") == 0) {
            this.doc.setMode(2);
            if (this.entry.indexOf("javac") == 0) {
                this.lastCompile = this.entry;
                new TermCompile(this.entry, this).start();
            } else if (this.entry.indexOf("java") == 0 && this.entry.trim().length() == 4) {
                this.lastCompile = this.entry;
                new TermCompile(this.entry, this).start();
            } else if (this.entry.indexOf("java ") == 0 && this.entry.trim().length() > 5) {
                IO.workingDir = this.pwd;
                String name = this.entry.substring(5).trim();
                if (name.indexOf("type.ec.Options") != -1 || name.indexOf("Options") != -1) {
                    this.optionAction(null);
                    this.acceptCommand();
                } else if (name.indexOf("type.ec.eCheck") != -1 || name.indexOf("eCheck") != -1) {
                    String labNo = name.substring(name.length() - 3).trim();
                    if (labNo.length() < 3) {
                        labNo = "0" + labNo;
                    }
                    if (!Options.isValidLabNo(labNo = labNo.toUpperCase())) {
                        this.showError("Invalid app number!\n");
                    } else {
                        this.eCheckAction(labNo);
                        this.lasteCheck = this.entry;
                    }
                    this.acceptCommand();
                } else {
                    this.runThread = new TermRun(this.entry, this);
                    this.lastRun = this.entry;
                    this.runThread.start();
                }
            } else {
                new TermCompile(this.entry, this).start();
            }
            this.entry = null;
        } else {
            if (this.entry.indexOf("ls") == 0 || this.entry.indexOf("dir") == 0) {
                File[] allFiles = new File(this.pwd).listFiles();
                Object[] list = new String[allFiles.length];
                int i = 0;
                while (i < allFiles.length) {
                    long when = allFiles[i].lastModified();
                    String s1 = String.valueOf(IO.format(when, "25")) + new Date(when).toString();
                    String s2 = allFiles[i].isDirectory() ? "<DIRECTORY>" : String.valueOf(IO.format(allFiles[i].length(), ",10")) + "B";
                    list[i] = String.valueOf(s1) + "   " + s2 + "   " + allFiles[i].getName();
                    ++i;
                }
                Arrays.sort(list);
                this.showOutput("Content of directory: " + this.pwd + "\n");
                this.showOutput("--- LAST MODIFIED [DESC] ---  --- SIZE ---   --- NAME -------------------------\n");
                i = list.length - 1;
                while (i >= 0) {
                    this.showOutput(((String)list[i]).substring(25));
                    this.showOutput("\n");
                    --i;
                }
                this.showOutput("--- LAST MODIFIED [DESC] ---  --- SIZE ---   --- NAME -------------------------\n");
                this.showCommand("listing completed.\n");
            } else if (this.entry.indexOf("pwd") == 0 || this.entry.indexOf("cd") == 0 && this.entry.trim().length() == 2) {
                this.showOutput("Working directory is: " + this.pwd + "\n");
                this.showCommand("pwd completed.\n");
            } else if (this.entry.indexOf("cls") == 0 || this.entry.indexOf("clear") == 0) {
                this.clearAll();
            } else if (this.entry.indexOf("cd") == 0 && this.entry.trim().length() > 2) {
                String dir = this.entry.substring(2).trim();
                File tmp1 = new File(dir);
                File tmp2 = new File(String.valueOf(this.pwd) + File.separator + dir);
                File tmp3 = new File("c:" + dir);
                if (tmp1.isAbsolute() && tmp1.exists()) {
                    this.pwd = this.getProperPath(tmp1);
                    this.showCommand("cd completed.\n");
                } else if (!tmp1.isAbsolute() && tmp2.exists()) {
                    this.pwd = this.getProperPath(tmp2);
                    this.showCommand("cd completed.\n");
                } else if (tmp3.exists()) {
                    this.pwd = this.getProperPath(tmp3);
                    this.showCommand("cd completed.\n");
                } else {
                    this.showError("No such directory!\n");
                }
            } else if (this.entry.indexOf("hr") == 0) {
                this.showCommand("inp = " + System.in);
                this.showCommand("err = " + System.err);
                this.showCommand("out = " + System.out);
                this.showCommand("\n");
            } else {
                this.showError("Unrecognized command!\n");
            }
            this.acceptCommand();
        }
    }

    void exec(char which) {
        if (which == 'C' && this.lastCompile != null) {
            this.entry = this.lastCompile;
            this.showCommand(this.entry);
            this.exec();
        } else if (which == 'R' && this.lastRun != null) {
            this.entry = this.lastRun;
            this.showCommand(this.entry);
            this.exec();
        } else if (which == 'E' && this.lasteCheck != null) {
            this.entry = this.lasteCheck;
            this.showCommand(this.entry);
            this.exec();
        } else {
            this.showError("No previous compile/run/eCheck were made!\n");
            this.acceptCommand();
        }
    }

    public void clearAll() {
        this.doc.setMode(-99);
        try {
            this.doc.remove(256, this.doc.getEndPosition().getOffset() - 257);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doc.setMode(0);
    }

    private String getProperPath(File maybe) {
        try {
            return maybe.getCanonicalPath();
        }
        catch (Exception e) {
            return maybe.getAbsolutePath();
        }
    }

    void eCheckAction(String labNo) {
        IO.workingDir = this.pwd;
        eCheckThread ect = new eCheckThread(labNo, this);
        ect.start();
    }

    void optionAction(JFrame parent) {
        new Options().action(parent);
    }
}

