/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import type.lang.IO;
import type.lib.Investment;
import type.lib.ToolBox;

public class Portfolio
implements Serializable,
Iterable<Investment> {
    public static final int DEFAULT_SIZE = 100;
    private String name;
    private int count;
    private Investment[] investment;
    private int cursor;
    private static Random rng = new Random();
    private static Portfolio lastPF = null;
    private static final long serialVersionUID = 1L;

    public Portfolio(String title, int capacity) {
        ToolBox.crash(capacity <= 0, "Capacity cannot be negative!");
        this.name = title;
        this.count = 0;
        this.investment = new Investment[capacity];
        IO.format("Portfolio", "1hamzeh0");
    }

    public Portfolio() {
        this("", 100);
    }

    public String getName() {
        return this.name;
    }

    public int getCapacity() {
        return this.investment.length;
    }

    public int size() {
        return this.count;
    }

    public Investment get(int index) {
        ToolBox.crash(index < 0 || index >= this.count, "Index out of range!");
        return this.investment[index];
    }

    @Override
    public Iterator<Investment> iterator() {
        Investment[] tmp = new Investment[this.count];
        System.arraycopy(this.investment, 0, tmp, 0, this.count);
        return Arrays.asList(tmp).iterator();
    }

    @Deprecated
    public Investment getFirst() {
        if (this.count == 0) {
            return null;
        }
        this.cursor = 0;
        return this.investment[this.cursor];
    }

    @Deprecated
    public Investment getNext() {
        if (this.cursor == this.count - 1) {
            return null;
        }
        ++this.cursor;
        return this.investment[this.cursor];
    }

    public boolean add(Investment inv) {
        if (this.count == this.investment.length) {
            return false;
        }
        this.investment[this.count] = inv;
        ++this.count;
        return true;
    }

    public Investment remove(int index) {
        ToolBox.crash(index < 0 || index >= this.count, "Index out of range!");
        Investment tmp = this.investment[index];
        int i = index;
        while (i < this.count - 1) {
            this.investment[i] = this.investment[i + 1];
            ++i;
        }
        --this.count;
        return tmp;
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.count;
    }

    public static Portfolio getRandom() {
        return Portfolio.getRandom(false);
    }

    public static Portfolio getRandom(boolean same) {
        if (same && lastPF != null) {
            return lastPF;
        }
        int num = 2 + rng.nextInt(19);
        String name = "";
        int i = 0;
        while (i < 4) {
            name = String.valueOf(name) + (char)(65 + rng.nextInt(26));
            ++i;
        }
        lastPF = new Portfolio("The Random Portfolio " + name, num + 10);
        i = 0;
        while (i < num) {
            lastPF.add(Investment.getRandom());
            ++i;
        }
        return lastPF;
    }
}

