/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import type.lang.IO;
import type.lib.CreditCard;
import type.lib.RewardCard;
import type.lib.ToolBox;

public class GlobalCredit
implements Serializable,
Iterable<CreditCard> {
    private Map<String, CreditCard> cards = new HashMap<String, CreditCard>();
    private String title;
    private Iterator<CreditCard> it;
    private static Random rng = new Random();
    private static GlobalCredit gcc = null;
    private static final long serialVersionUID = 1L;

    public GlobalCredit(String name) {
        this.title = name;
        IO.format("GlobalCredit", "1hamzeh0");
    }

    public GlobalCredit() {
        this("NoName");
    }

    public boolean add(CreditCard card) {
        ToolBox.crash(card == null, "Null object!");
        if (this.cards.containsKey(card.getNumber())) {
            return false;
        }
        this.cards.put(card.getNumber(), card);
        return true;
    }

    public CreditCard remove(String number) {
        return this.cards.remove(number);
    }

    public CreditCard get(String number) {
        return this.cards.get(number);
    }

    public int size() {
        return this.cards.size();
    }

    public String toString() {
        return "Global Credit Company [" + this.title + "]: CARDS=" + this.cards.size();
    }

    @Override
    public Iterator<CreditCard> iterator() {
        return this.cards.values().iterator();
    }

    @Deprecated
    public CreditCard getFirst() {
        this.it = this.cards.values().iterator();
        return this.getNext();
    }

    @Deprecated
    public CreditCard getNext() {
        CreditCard tmp = null;
        if (this.it.hasNext()) {
            tmp = this.it.next();
        } else {
            this.it = null;
        }
        return tmp;
    }

    public static GlobalCredit getRandom() {
        return GlobalCredit.getRandom(false);
    }

    public static GlobalCredit getRandom(boolean same) {
        if (same && gcc != null) {
            return gcc;
        }
        int num = 2 + rng.nextInt(19);
        int special = rng.nextInt(num);
        gcc = new GlobalCredit();
        int i = 0;
        while (i < num) {
            int no = 1 + rng.nextInt(999999);
            if (i == special) {
                no = 123456;
            }
            CreditCard cc = rng.nextInt(4) < 3 ? new CreditCard(no, "Random") : new RewardCard(no, "Random");
            double c = (rng.nextGaussian() / 5.0 + 1.0) * 500.0;
            double p = (rng.nextGaussian() / 50.0 + 1.0) * 500.0;
            if (p > c) {
                p /= 2.0;
            }
            cc.charge(c);
            cc.pay(p);
            Date exp = cc.getExpiryDate();
            Calendar cal = Calendar.getInstance();
            cal.setTime(exp);
            cal.add(10, rng.nextInt(50000));
            cc.setExpiryDate(cal.getTime());
            gcc.add(cc);
            ++i;
        }
        return gcc;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.it = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.it = null;
        in.defaultReadObject();
    }
}

