/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import type.lang.IO;

class Crypter {
    private final int[] dollar = new int[]{10, 13, 15, 17, 14, 14, 9, 14, 16, 10, 13, 15, 14, 15};
    private final int[] cent;
    private final int WEEK_DAYS = 7;
    private final int ROTORSZ = 256;
    private final int MASK = 255;
    private final int PWSIZE = 13;
    private char[] t1;
    private char[] t2;
    private char[] t3;
    private char[] deck;
    private char[] buf;
    private String pswd;

    Crypter() {
        int[] nArray = new int[14];
        nArray[0] = 2;
        nArray[1] = 6;
        nArray[2] = 4;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 6;
        nArray[6] = 2;
        nArray[8] = 5;
        nArray[9] = 2;
        nArray[10] = 6;
        nArray[11] = 4;
        nArray[12] = 2;
        this.cent = nArray;
        this.WEEK_DAYS = 7;
        this.ROTORSZ = 256;
        this.MASK = 255;
        this.PWSIZE = 13;
        this.t1 = new char[256];
        this.t2 = new char[256];
        this.t3 = new char[256];
        this.deck = new char[256];
        this.buf = new char[13];
        StringBuffer tmp = new StringBuffer(14);
        int i = 0;
        while (i < 14) {
            tmp.append((char)(this.dollar[i] * 7 + this.cent[i]));
            ++i;
        }
        this.pswd = tmp.toString();
    }

    Crypter(String pw) {
        int[] nArray = new int[14];
        nArray[0] = 2;
        nArray[1] = 6;
        nArray[2] = 4;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 6;
        nArray[6] = 2;
        nArray[8] = 5;
        nArray[9] = 2;
        nArray[10] = 6;
        nArray[11] = 4;
        nArray[12] = 2;
        this.cent = nArray;
        this.WEEK_DAYS = 7;
        this.ROTORSZ = 256;
        this.MASK = 255;
        this.PWSIZE = 13;
        this.t1 = new char[256];
        this.t2 = new char[256];
        this.t3 = new char[256];
        this.deck = new char[256];
        this.buf = new char[13];
        this.pswd = new String(pw);
    }

    void crypt(byte[] sbuf, boolean en) {
        int frm;
        int inc = en ? 1 : -1;
        int i = frm = en ? 0 : this.dollar.length - 1;
        while (i < this.dollar.length && i >= 0) {
            byte tmp = sbuf[this.dollar[i]];
            sbuf[this.dollar[i]] = sbuf[this.cent[i]];
            sbuf[this.cent[i]] = tmp;
            i += inc;
        }
    }

    String crypt(String sbuf) {
        StringBuffer buf = new StringBuffer(sbuf);
        this.crypt(buf);
        return buf.toString();
    }

    String crypt(String secret, boolean en, boolean crc) {
        if (secret == null || secret.length() == 0) {
            return "";
        }
        String out = "";
        if (en) {
            String in = this.crypt(secret);
            int i = 0;
            while (i < in.length()) {
                out = String.valueOf(out) + IO.format(in.charAt(i), "x");
                ++i;
            }
            if (!crc) {
                return out;
            }
            if (out.length() == 0) {
                return "";
            }
            int sum = 0;
            int i2 = 0;
            while (i2 < out.length()) {
                sum += Integer.parseInt("" + out.charAt(i2), 16);
                ++i2;
            }
            int check = sum % 16 != 0 ? 16 - sum % 16 : 0;
            return "0123456789abcdef".charAt(check) + out;
        }
        if (crc) {
            long sum = 0L;
            int i = 0;
            while (i < secret.length()) {
                sum += (long)Integer.parseInt("" + secret.charAt(i), 16);
                ++i;
            }
            if (sum % 16L != 0L) {
                return "";
            }
            secret = secret.substring(1);
        }
        int i = 0;
        while (i < secret.length()) {
            out = String.valueOf(out) + (char)Integer.parseInt(secret.substring(i, i + 4), 16);
            i += 4;
        }
        return this.crypt(out);
    }

    private void setup(String pw) {
        int i = 0;
        while (i < 256) {
            this.deck[i] = '\u0000';
            this.t3[i] = '\u0000';
            this.t2[i] = '\u0000';
            this.t1[i] = '\u0000';
            ++i;
        }
        i = 0;
        while (i < 13) {
            this.buf[i] = '\u0000';
            ++i;
        }
        i = 0;
        while (i < 13 && i < pw.length()) {
            this.buf[i] = pw.charAt(i);
            ++i;
        }
        long seed = 123L;
        i = 0;
        while (i < 13) {
            seed = seed * (long)this.buf[i] + (long)i;
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.t1[i] = this.deck[i] = (char)i;
            ++i;
        }
        i = 0;
        while (i < 256) {
            seed = 5L * seed + (long)this.buf[i % 13];
            int random = (int)seed % 65521;
            int k = 255 - i;
            int ic = (random & 0xFF) % (k + 1);
            random >>= 8;
            char temp = this.t1[k];
            this.t1[k] = this.t1[ic];
            this.t1[ic] = temp;
            if (this.t3[k] == '\u0000') {
                ic = (random & 0xFF) % k;
                while (this.t3[ic] != '\u0000') {
                    ic = (ic + 1) % k;
                }
                this.t3[k] = (char)ic;
                this.t3[ic] = (char)k;
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.t2[this.t1[i] & 0xFF] = (char)i;
            ++i;
        }
    }

    private void crypt(StringBuffer sbuf) {
        this.setup(this.pswd);
        int n1 = 0;
        int n2 = 0;
        int nr2 = 0;
        int bufflen = sbuf.length();
        int j = 0;
        while (j < bufflen) {
            char i = sbuf.charAt(j);
            int nr1 = n1++;
            i = (char)(this.t2[this.t3[this.t1[i + nr1 & 0xFF] + nr2 & 0xFF] - nr2 & 0xFF] - nr1);
            sbuf.setCharAt(j, i);
            if (n1 == 256) {
                n1 = 0;
                if (++n2 == 256) {
                    n2 = 0;
                }
                nr2 = n2;
            }
            ++j;
        }
    }
}

