/*
 * Decompiled with CFR 0.152.
 */
package type.ec;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import type.lang.IO;
import type.lang.UniReader;
import type.lang.UniWriter;

public class Options {
    public static final String VERSION = "7A";
    public static final String SLASH = System.getProperty("file.separator");
    public static final String HOME = System.getProperty("user.home");
    private static String[] data = null;
    private JDialog jd;
    private JButton button;
    private JButton cancel;
    private JTextField login;
    private JTextField ecURL;
    private JPasswordField pswrd;
    private JCheckBox chkBox;

    public Options() {
        if (data == null) {
            data = new String[8];
            Options.getCookie();
        }
    }

    public String getStartup() {
        return data[5];
    }

    public void setStartup(String dir) {
        Options.data[5] = dir;
        Options.setCookie();
    }

    String[] getOptions() {
        return data;
    }

    void setOptions(String[] info) {
        data = info;
        Options.setCookie();
    }

    private static void getCookie() {
        Options.data[0] = "0";
        Options.data[1] = "";
        Options.data[2] = "";
        Options.data[3] = "9999";
        Options.data[4] = "URL of eCheck server (if available)";
        Options.data[5] = HOME;
        Options.data[7] = "T";
        UniReader bfr = null;
        try {
            bfr = new UniReader(String.valueOf(HOME) + SLASH + ".UCrc");
            String tmp = bfr.readLine();
            tmp = IO.format(tmp, "2hamzeh3");
            Options.data[0] = tmp.substring(0, 4);
            Options.data[3] = tmp.substring(4, 8);
            int ln1 = Integer.parseInt(tmp.substring(8, 10));
            Options.data[1] = tmp.substring(12, 12 + ln1);
            int ln2 = Integer.parseInt(tmp.substring(10, 12));
            Options.data[2] = tmp.substring(12 + ln1, 12 + ln1 + ln2);
            tmp = bfr.readLine();
            if (!bfr.eof() && tmp != null && tmp.trim().length() > 9) {
                Options.data[4] = tmp.trim();
            }
            tmp = bfr.readLine();
            if (!bfr.eof() && tmp != null && tmp.trim().length() > 0) {
                Options.data[5] = tmp.trim();
            }
            tmp = bfr.readLine();
            if (!bfr.eof() && tmp != null && tmp.trim().length() > 0) {
                Options.data[7] = tmp.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bfr != null) {
            bfr.close();
        }
        Options.setPacket();
    }

    private static void setCookie() {
        Options.setPacket();
        UniWriter bfr = new UniWriter(String.valueOf(HOME) + SLASH + ".UCrc");
        bfr.println(IO.format(String.valueOf(IO.format(data[0].trim(), "4Z")) + IO.format(data[3].trim(), "4Z") + data[6], "2hamzeh2"));
        bfr.println(data[4]);
        bfr.println(data[5]);
        bfr.println(data[7]);
        bfr.close();
    }

    private static void setPacket() {
        Options.data[6] = String.valueOf(IO.format(data[1].length(), "2Z")) + IO.format(data[2].length(), "2Z") + data[1] + data[2];
    }

    public static void main(String[] args) {
        new Options().action(null);
        System.exit(0);
    }

    public void action(JFrame parent) {
        Options.getCookie();
        this.jd = new JDialog(parent, "Options /version 7A", true);
        Container cjd = this.jd.getContentPane();
        cjd.setLayout(new BoxLayout(cjd, 1));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        boolean selected = data[7].equals("T");
        this.chkBox = new JCheckBox(" Work Offline (no marks will be recorded)", selected);
        this.chkBox.setHorizontalAlignment(0);
        topPanel.add(this.chkBox);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        JLabel lbl = new JLabel("Login ID");
        lbl.setAlignmentX(0.5f);
        jp.add(lbl);
        this.login = new JTextField(data[1], 10);
        this.login.setFont(new Font("Monospaced", 0, 14));
        this.login.setForeground(Color.BLUE);
        jp.add(this.login);
        jp.add(Box.createRigidArea(new Dimension(0, 20)));
        lbl = new JLabel("Password");
        lbl.setAlignmentX(0.5f);
        jp.add(lbl);
        this.pswrd = new JPasswordField(data[2], 10);
        this.pswrd.setFont(new Font("Monospaced", 0, 14));
        this.pswrd.setForeground(Color.BLUE);
        jp.add(this.pswrd);
        jp.add(Box.createRigidArea(new Dimension(0, 20)));
        lbl = new JLabel("eCheck URL");
        lbl.setAlignmentX(0.5f);
        jp.add(lbl);
        this.ecURL = new JTextField(data[4], 35);
        this.ecURL.setFont(new Font("Monospaced", 0, 14));
        this.ecURL.setForeground(Color.BLUE);
        jp.add(this.ecURL);
        jp.add(Box.createRigidArea(new Dimension(0, 20)));
        this.button = new JButton("Apply");
        this.cancel = new JButton("Cancel");
        JPanel jp2 = new JPanel();
        jp2.setLayout(new BoxLayout(jp2, 0));
        jp2.add(this.cancel);
        jp2.add(Box.createRigidArea(new Dimension(50, 0)));
        jp2.add(this.button);
        jp.add(jp2);
        jp.add(Box.createRigidArea(new Dimension(0, 20)));
        cjd.add(topPanel);
        cjd.add(Box.createRigidArea(new Dimension(0, 20)));
        cjd.add(jp);
        this.jd.setDefaultCloseOperation(2);
        this.enableInput(!data[7].equals("T"));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                data[1] = Options.this.login.getText();
                data[2] = new String(Options.this.pswrd.getPassword());
                data[4] = Options.this.ecURL.getText().trim();
                data[7] = Options.this.chkBox.isSelected() ? "T" : "F";
                Options.setCookie();
                Options.this.jd.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Options.this.jd.dispose();
            }
        });
        this.chkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Options.this.enableInput(!Options.this.chkBox.isSelected());
            }
        });
        this.jd.pack();
        this.jd.setLocationRelativeTo(parent);
        this.jd.setVisible(true);
    }

    private void enableInput(boolean state) {
        this.login.setEnabled(state);
        this.ecURL.setEnabled(state);
        this.pswrd.setEnabled(state);
    }

    public static boolean isValidLabNo(String num) {
        boolean valid = false;
        if (num != null && num.length() == 3 && "0123456789".indexOf(num.charAt(0)) != -1 && "0123456789".indexOf(num.charAt(1)) != -1 && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(num.charAt(2)) != -1) {
            valid = true;
        }
        return valid;
    }
}

