/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import type.uc.Terminal;

class TermDoc
extends DefaultStyledDocument {
    private Terminal term;
    private int mode = 0;
    private AttributeSet[] attribute = new AttributeSet[5];
    private int mark;

    TermDoc() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.green.darker());
        StyleConstants.setBold(simpleAttributeSet, true);
        this.attribute[0] = simpleAttributeSet;
        this.attribute[3] = simpleAttributeSet;
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyleConstants.setItalic(simpleAttributeSet, true);
        StyleConstants.setBold(simpleAttributeSet, true);
        this.attribute[1] = simpleAttributeSet;
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setItalic(simpleAttributeSet, false);
        this.attribute[2] = simpleAttributeSet;
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.red);
        this.attribute[4] = simpleAttributeSet;
    }

    void setTerminal(Terminal terminal) {
        this.term = terminal;
    }

    void setMode(int n) {
        this.mode = n;
        this.mark = this.getEndPosition().getOffset() - 1;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.mode > 1 || string == null) {
            return;
        }
        int n2 = string.indexOf("\n");
        super.insertString(this.getEndPosition().getOffset() - 1, string, this.attribute[Math.abs(this.mode)]);
        try {
            if (n2 != -1 && this.mode >= 0) {
                this.term.entry = this.getText(this.mark, this.getEndPosition().getOffset() - this.mark - 1);
                if (this.mode == 0) {
                    this.term.exec();
                } else {
                    this.mode = 2;
                }
            }
            this.term.setCaretPosition(this.getEndPosition().getOffset() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void print(String string, int n) {
        if (n <= 1) {
            return;
        }
        this.mode = -n;
        try {
            this.insertString(1, string, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mode = n;
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.mode > 1) {
            return;
        }
        if (this.mode == -99) {
            super.remove(n, n2);
        }
        if (this.getEndPosition().getOffset() == n + 2 && n >= this.mark) {
            super.remove(n, n2);
        }
    }
}

