/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lang.SE;
import type.lib.Investment;

public class Portfolio
implements Serializable {
    public static final int DEFAULT_SIZE = 100;
    private String name;
    private int count;
    private Investment[] investment;
    private int cursor;
    private static Random rng = new Random();

    public Portfolio(String string, int n) {
        SE.require(n > 0);
        this.name = string;
        this.count = 0;
        this.investment = new Investment[n];
        IO.format("Portfolio", "1hamzeh0");
    }

    public Portfolio() {
        this("", 100);
    }

    public int size() {
        return this.count;
    }

    public Investment get(int n) {
        SE.require(n >= 0 && n < this.count);
        return this.investment[n];
    }

    public Investment getFirst() {
        if (this.count == 0) {
            return null;
        }
        this.cursor = 0;
        return this.investment[this.cursor];
    }

    public Investment getNext() {
        if (this.cursor == this.count - 1) {
            return null;
        }
        ++this.cursor;
        return this.investment[this.cursor];
    }

    public boolean add(Investment investment) {
        if (this.count == this.investment.length) {
            return false;
        }
        this.investment[this.count] = investment;
        ++this.count;
        return true;
    }

    public String toString() {
        return this.name + ": " + this.count;
    }

    public static Portfolio getRandom() {
        int n = 2 + rng.nextInt(19);
        Portfolio portfolio = new Portfolio("The Random Portfolio", n);
        int n2 = 0;
        while (n2 < n) {
            portfolio.add(Investment.getRandom());
            ++n2;
        }
        return portfolio;
    }
}

