/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lang.SE;

public class Student
implements Serializable {
    private String id;
    private String name;
    private String record;
    private final String DIGITS = "0123456789";
    private final String GRADES = "ABCDEFabcdef";
    private int start;

    public Student(String string, String string2) {
        SE.require(this.isDigit(string) && string.length() == 9);
        this.id = string;
        this.name = string2;
        this.record = "";
        IO.format("Student", "1hamzeh0");
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFirstCourse() {
        if (this.record.length() == 0) {
            return null;
        }
        this.start = 0;
        return this.getNextCourse();
    }

    public String getNextCourse() {
        String string = null;
        if (this.start < this.record.length()) {
            string = this.record.substring(this.start, this.start + 4);
            this.start += 5;
        }
        return string;
    }

    public String getCourseGrade(String string) {
        int n = this.record.indexOf(string);
        String string2 = null;
        if (n != -1) {
            string2 = this.record.substring(n + 4, n + 5);
        }
        return string2;
    }

    public boolean setCourseGrade(String string, String string2) {
        string2 = string2.toUpperCase();
        boolean bl = string.length() == 4;
        bl = bl && string2.length() == 1;
        bl = bl && "ABCDEFabcdef".indexOf(string2) != -1;
        boolean bl2 = bl = bl && this.isDigit(string);
        if (bl) {
            int n = this.record.indexOf(string);
            this.record = n != -1 ? this.record.substring(0, n + 4) + string2 + this.record.substring(n + 5) : this.record + string + string2;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Student)) {
            return false;
        }
        Student student = (Student)object;
        return this.id.equals(student.getID());
    }

    public double getGpa() {
        double d = 0.0;
        int n = 0;
        int n2 = 4;
        while (n2 <= this.record.length()) {
            d -= (double)this.record.substring(n2, n2 + 1).compareTo("F");
            ++n;
            n2 += 5;
        }
        return d / (double)n;
    }

    public String toString() {
        return "COSC student: " + this.name;
    }

    private boolean isDigit(String string) {
        int n = 0;
        while (n < string.length()) {
            if ("0123456789".indexOf(string.substring(n, n + 1)) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

