/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lib.Stock;

public class Investment
implements Serializable {
    private Stock stock;
    private int qty;
    private double bookValue;
    private static Random rng = new Random();

    public Investment(Stock stock, int n, double d) {
        this.stock = stock;
        this.qty = n;
        this.bookValue = d;
        IO.format("Investment", "1hamzeh0");
    }

    public Stock getStock() {
        return this.stock;
    }

    public int getQty() {
        return this.qty;
    }

    public double getBookValue() {
        return this.bookValue;
    }

    public String toString() {
        return this.stock.toString() + " QTY=" + this.qty + " BV=" + this.bookValue;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Investment && ((Investment)object).getStock().equals(this.stock) && Math.abs(((Investment)object).getBookValue() - this.bookValue) < 0.01;
    }

    public Investment cloneMe() {
        return new Investment(this.stock.cloneMe(), this.qty, this.bookValue);
    }

    public static Investment getRandom() {
        char c = (char)(65 + rng.nextInt(26));
        Stock stock = new Stock("HR." + c);
        return new Investment(stock, 1 + rng.nextInt(5000), (rng.nextGaussian() / 50.0 + 1.0) * stock.getPrice());
    }
}

