/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lang.SE;

public class Fraction
implements Serializable {
    private long numer;
    private long denom;
    protected static Random rng = new Random();

    public Fraction() {
        this(0L, 1L);
    }

    public Fraction(long l, long l2) {
        IO.format("Fraction", "1hamzeh0");
        if (l2 < 0L) {
            this.numer = -l;
            this.denom = -l2;
        } else {
            this.numer = l;
            this.denom = l2;
        }
        SE.check(this.denom >= 0L);
        this.reduce();
    }

    public void add(Fraction fraction) {
        if (this.denom == 0L || fraction.getDenominator() == 0L) {
            this.numer = this.numer * fraction.getDenominator() + fraction.getNumerator() * this.denom;
            this.denom *= fraction.getDenominator();
        } else {
            long l = Fraction.lcm(this.denom, fraction.getDenominator());
            this.numer = this.numer * (l / this.denom) + fraction.getNumerator() * (l / fraction.getDenominator());
            this.denom = l;
            this.reduce();
        }
    }

    public void subtract(Fraction fraction) {
        Fraction fraction2 = new Fraction(-fraction.getNumerator(), fraction.getDenominator());
        this.add(fraction2);
    }

    public void multiply(Fraction fraction) {
        this.numer *= fraction.numer;
        this.denom *= fraction.denom;
        this.reduce();
    }

    public void divide(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction.denom, fraction.numer);
        this.multiply(fraction2);
    }

    public void pow(int n) {
        SE.require(n >= 0);
        if (n > 1) {
            boolean bl = n / 2 * 2 == n;
            Fraction fraction = new Fraction(this.getNumerator(), this.getDenominator());
            this.pow(n / 2);
            Fraction fraction2 = new Fraction(this.getNumerator(), this.getDenominator());
            this.multiply(fraction2);
            if (!bl) {
                this.multiply(fraction);
            }
        } else if (n == 0) {
            this.numer = 1L;
            this.denom = 1L;
        }
    }

    public long getNumerator() {
        return this.numer;
    }

    public long getDenominator() {
        return this.denom;
    }

    public String toString() {
        if (this.denom == 0L) {
            return "NaF";
        }
        return this.numer + "/" + this.denom;
    }

    public String toProperString() {
        if (this.denom == 0L || Math.abs(this.numer) < this.denom) {
            return this.toString();
        }
        long l = this.numer / this.denom;
        return "" + l + " " + this.numer % this.denom + "/" + this.denom;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)object;
        return this.getNumerator() * fraction.getDenominator() == this.getDenominator() * fraction.getNumerator();
    }

    public boolean resembles(Fraction fraction) {
        if (fraction == null) {
            return false;
        }
        return this.getDenominator() == fraction.getDenominator();
    }

    public static Fraction getRandom() {
        return new Fraction(rng.nextInt(1000), 1 + rng.nextInt(1000));
    }

    public static void setSeed(long l) {
        rng.setSeed(l);
    }

    private void reduce() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l == 0L || l2 == 0L) {
            return;
        }
        long l3 = Fraction.euc(l, l2);
        this.numer /= l3;
        this.denom /= l3;
    }

    private static long lcm(long l, long l2) {
        return l * l2 / Fraction.euc(l, l2);
    }

    private static long euc(long l, long l2) {
        long l3;
        if (l == 0L || l2 == 0L) {
            return 1L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l < l2) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }
}

