/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lang.UniReader;

public class StockNS
implements Serializable {
    private String ticker = null;
    private double price = 0.0;
    public String name = null;
    public char delimiter = (char)32;
    public static boolean titleCaseName = false;
    public static final String TSE_URL = "http://www.tse.com/HttpController?GetPage=QuotesViewPage&DetailedView=DetailedPrices&Language=en&QuoteSymbol_1=";
    private static final String NAME_KEYWORD = "Instrument<BR>Name:</TD>";
    private static final String PRICE_KEYWORD = "Last Traded</TD>";
    private static final String NOT_FOUND_KEYWORD = "The following invalid symbols were found:";

    public StockNS() {
        IO.format("StockNS", "1hamzeh0");
    }

    public StockNS(String string) {
        IO.format("StockNS", "1hamzeh0");
        this.setSymbol(string);
    }

    public String getName() {
        if (this.name != null & titleCaseName) {
            String string = "";
            int n = this.name.length() - 1;
            while (n > 0) {
                char c = this.name.charAt(n);
                if (Character.isLetter(c) && Character.isLetter(this.name.charAt(n - 1))) {
                    c = Character.toLowerCase(c);
                }
                string = c + string;
                --n;
            }
            return this.name.charAt(0) + string;
        }
        return this.name;
    }

    public String getSymbol() {
        return this.ticker;
    }

    public double getPrice() {
        return this.price;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean setDelimiter(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        this.delimiter = c;
        return true;
    }

    public void setSymbol(String string) {
        this.ticker = string.toUpperCase();
        this.refresh();
    }

    public void refresh() {
        if (this.ticker.indexOf("HR.") == 0) {
            this.fake();
            return;
        }
        UniReader uniReader = new UniReader(TSE_URL + this.ticker);
        String string = uniReader.readLine();
        while (!uniReader.eof()) {
            int n;
            int n2;
            int n3 = string.indexOf(NAME_KEYWORD);
            if (n3 != -1 && (n2 = (string = uniReader.readLine()).indexOf(">")) < (n = string.indexOf("<", n2 + 1))) {
                this.name = string.substring(n2 + 1, n);
            }
            if (string.indexOf(PRICE_KEYWORD) != -1 && (n2 = (string = uniReader.readLine()).indexOf(">")) < (n = string.indexOf("<", n2 + 1))) {
                this.price = Double.parseDouble(string.substring(n2 + 1, n));
                break;
            }
            if (string.indexOf(NOT_FOUND_KEYWORD) != -1) {
                this.price = 0.0;
                break;
            }
            string = uniReader.readLine();
        }
        uniReader.close();
    }

    public StockNS cloneMe() {
        StockNS stockNS = new StockNS();
        stockNS.ticker = this.ticker;
        stockNS.price = this.price;
        stockNS.name = this.name;
        stockNS.delimiter = this.delimiter;
        return stockNS;
    }

    private void fake() {
        String string = this.ticker.substring(3, 4);
        int n = string.compareTo("A") + 1;
        this.name = n % 2 == 0 ? string + "TECH INC." : "THE " + string + "COMP CORPORATION";
        this.price = (double)n + (double)n / 100.0;
    }
}

