/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.CreditCard;

public class RewardCard
extends CreditCard {
    public static final int REWARD_RATE = 20;
    private int points = 0;

    public RewardCard(int n, String string, double d) {
        super(n, string, d);
        IO.format("RewardCard", "1hamzeh0");
    }

    public double getRewardPoints() {
        return this.points;
    }

    public boolean charge(double d) {
        if (super.charge(d)) {
            this.points = (int)((double)this.points + Math.floor(d / 20.0));
            return true;
        }
        return false;
    }

    public void credit(double d) {
        super.credit(d);
        this.points = (int)((double)this.points - Math.floor(d / 20.0));
    }

    public void redeemPoints() {
        this.points = 0;
    }

    public String toString() {
        String string = super.toString();
        return "RWRD" + string.substring(4, string.length() - 1) + ", POINTS=" + this.points + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof RewardCard) {
            RewardCard rewardCard = (RewardCard)object;
            return this.getNumber().equals(rewardCard.getNumber()) && this.points == rewardCard.points;
        }
        return false;
    }
}

