/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lang.SE;

public class Fraction
implements Serializable {
    private long numer;
    private long denom;

    public Fraction() {
        this(0L, 1L);
    }

    public Fraction(long l, long l2) {
        IO.format("Fraction", "1hamzeh0");
        if (l2 < 0L) {
            this.numer = -l;
            this.denom = -l2;
        } else {
            this.numer = l;
            this.denom = l2;
        }
        SE.check(this.denom >= 0L);
        this.reduce();
    }

    public void add(Fraction fraction) {
        if (this.denom == 0L || fraction.getDenominator() == 0L) {
            this.numer = this.numer * fraction.getDenominator() + fraction.getNumerator() * this.denom;
            this.denom *= fraction.getDenominator();
        } else {
            long l = Fraction.lcm(this.denom, fraction.getDenominator());
            this.numer = this.numer * (l / this.denom) + fraction.getNumerator() * (l / fraction.getDenominator());
            this.denom = l;
            this.reduce();
        }
    }

    public void subtract(Fraction fraction) {
        Fraction fraction2 = new Fraction(-fraction.getNumerator(), fraction.getDenominator());
        this.add(fraction2);
    }

    public void multiply(Fraction fraction) {
        this.numer *= fraction.numer;
        this.denom *= fraction.denom;
        this.reduce();
    }

    public void divide(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction.denom, fraction.numer);
        this.multiply(fraction2);
    }

    public long getNumerator() {
        return this.numer;
    }

    public void pow(int n) {
        SE.require(n >= 0);
        if (n > 1) {
            boolean bl = n / 2 * 2 == n;
            Fraction fraction = new Fraction(this.getNumerator(), this.getDenominator());
            this.pow(n / 2);
            Fraction fraction2 = new Fraction(this.getNumerator(), this.getDenominator());
            this.multiply(fraction2);
            if (!bl) {
                this.multiply(fraction);
            }
        } else if (n == 0) {
            this.numer = 1L;
            this.denom = 1L;
        }
    }

    public long getDenominator() {
        return this.denom;
    }

    public String toString() {
        if (this.denom == 0L) {
            return "NaF";
        }
        return this.numer + "/" + this.denom;
    }

    public String toProperString() {
        if (this.denom == 0L || Math.abs(this.numer) < this.denom) {
            return this.toString();
        }
        long l = this.numer / this.denom;
        return "" + l + " " + this.numer % this.denom + "/" + this.denom;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)object;
        return this.getNumerator() * fraction.getDenominator() == this.getDenominator() * fraction.getNumerator();
    }

    private void reduce() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l < 0L) {
            l = -l;
        }
        long l3 = l;
        if (l2 < l) {
            l3 = l2;
        }
        long l4 = 1L;
        long l5 = l3;
        while (l5 > 1L) {
            if (l % l5 == 0L && l2 % l5 == 0L) {
                l4 = l5;
                break;
            }
            --l5;
        }
        this.numer /= l4;
        this.denom /= l4;
    }

    private static long lcm(long l, long l2) {
        long l3 = l * l2;
        long l4 = l;
        if (l2 > l) {
            l4 = l2;
        }
        long l5 = l4;
        while (l5 < l * l2) {
            if (l5 % l == 0L && l5 % l2 == 0L) {
                l3 = l5;
                break;
            }
            ++l5;
        }
        return l3;
    }
}

