/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lang.SE;

public class Equation
implements Serializable {
    private double coef2;
    private double coef1;
    private double coef0;
    private double root1;
    private double root2;
    private int rootCount;
    public static final double EPSILON = 1.0E-6;

    public Equation() {
        this(0.0, 0.0, 0.0);
    }

    public Equation(double d, double d2, double d3) {
        IO.format("Equation", "1hamzeh0");
        this.setCoefficient(d, d2, d3);
    }

    public void setCoefficient(double d, double d2, double d3) {
        this.coef0 = d3;
        this.coef1 = d2;
        this.coef2 = d;
        this.findRoot();
    }

    public double getCoefficient(int n) {
        SE.require(n >= 0 && n <= 2);
        if (n == 0) {
            return this.coef0;
        }
        if (n == 1) {
            return this.coef1;
        }
        return this.coef2;
    }

    public double getRoot(int n) {
        SE.require(n > 0 && n <= this.rootCount);
        if (n == 1) {
            return this.root1;
        }
        return this.root2;
    }

    public int getRootCount() {
        return this.rootCount;
    }

    private void findRoot() {
        if (this.coef2 == 0.0) {
            if (this.coef1 == 0.0) {
                this.rootCount = this.coef0 == 0.0 ? -1 : 0;
            } else {
                this.rootCount = 1;
                this.root1 = -this.coef0 / this.coef1;
            }
        } else {
            double d = this.coef1 * this.coef1 - 4.0 * this.coef2 * this.coef0;
            if (d < 0.0) {
                this.rootCount = 0;
            } else if (d == 0.0) {
                this.rootCount = 1;
                this.root1 = -this.coef1 / (2.0 * this.coef2);
            } else {
                this.rootCount = 2;
                this.root1 = (-this.coef1 - Math.sqrt(d)) / (2.0 * this.coef2);
                this.root2 = (-this.coef1 + Math.sqrt(d)) / (2.0 * this.coef2);
                if (this.root2 < this.root1) {
                    double d2 = this.root1;
                    this.root1 = this.root2;
                    this.root2 = d2;
                }
            }
        }
    }

    public String toString() {
        String string = this.coef2 + "x^2 ";
        string = this.coef1 >= 0.0 ? string + "+ " : string + "- ";
        string = string + Math.abs(this.coef1) + "x ";
        string = this.coef0 >= 0.0 ? string + "+ " : string + "- ";
        string = string + Math.abs(this.coef0) + "  =  0";
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Equation)) {
            return false;
        }
        Equation equation = (Equation)object;
        if (this.rootCount != equation.getRootCount()) {
            return false;
        }
        if (this.rootCount == 1) {
            return Math.abs(this.root1 - equation.getRoot(1)) < 1.0E-6;
        }
        if (this.rootCount == 2) {
            return Math.abs(this.root1 - equation.getRoot(1)) < 1.0E-6 && Math.abs(this.root2 - equation.getRoot(2)) < 1.0E-6;
        }
        return true;
    }
}

