/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lang.SE;
import type.lib.Investment;
import type.lib.Stock;

public class Portfolio
implements Serializable {
    public static final int DEFAULT_SIZE = 100;
    private String name;
    private int count;
    private Investment[] investment;
    private int cursor;
    private static String[] tickers = new String[]{"HR.A", "HR.D", "HR.F", "HR.J", "HR.K", "HR.M", "HR.P", "HR.Q", "HR.S", "HR.X", "AT", "AMR", "ATY", "BMO", "BNS", "BP.U", "CGS.A", "CLS", "DW", "FCE.UN", "GWO", "HSB.PR.A", "MHR", "MCL", "NT", "RCI.A", "RY", "SPZ", "TEL.B", "TD"};

    public Portfolio(String string, int n) {
        SE.require(n > 0);
        this.name = string;
        this.count = 0;
        this.investment = new Investment[n];
        IO.format("Portfolio", "1hamzeh0");
    }

    public Portfolio() {
        this("", 100);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public Investment getInvestment(int n) {
        SE.require(n >= 0 && n < this.count);
        return this.investment[n].cloneMe();
    }

    public Investment getFirst() {
        if (this.count == 0) {
            return null;
        }
        this.cursor = 0;
        return this.investment[this.cursor];
    }

    public Investment getNext() {
        if (this.cursor == this.count - 1) {
            return null;
        }
        ++this.cursor;
        return this.investment[this.cursor];
    }

    public boolean add(Investment investment) {
        if (this.count == this.investment.length) {
            return false;
        }
        this.investment[this.count] = investment;
        ++this.count;
        return true;
    }

    public String toString() {
        return this.name + ": " + this.count;
    }

    public static Portfolio getRandom() {
        Random random = new Random();
        int n = 10;
        int n2 = tickers.length - n;
        if (tickers[0].charAt(3) == 'A') {
            n2 = n;
            n = 0;
            Portfolio.tickers[0] = "HR.B";
        }
        int n3 = 2 + random.nextInt(n2 - 1);
        Portfolio portfolio = new Portfolio("The Random Portfolio", n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + random.nextInt(n2);
            Stock stock = new Stock(tickers[n5]);
            portfolio.add(new Investment(stock, 1 + random.nextInt(5000), (random.nextGaussian() / 50.0 + 1.0) * stock.getPrice()));
            ++n4;
        }
        return portfolio;
    }
}

