/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lib.CreditCard;
import type.lib.RewardCard;

public class GlobalCredit
implements Serializable {
    public static final int DEFAULT_MAX = 100;
    private CreditCard[] cards;
    private int size;
    private int start;
    private String title;

    public GlobalCredit(String string, int n) {
        this.cards = new CreditCard[n];
        this.size = 0;
        this.title = string;
        IO.format("GlobalCredit", "1hamzeh0");
    }

    public GlobalCredit() {
        this("NoName", 100);
    }

    public boolean charge(String string, double d) {
        int n = this.find(string);
        if (n >= 0) {
            return this.cards[n].charge(d);
        }
        return false;
    }

    public boolean redeemPoints(String string) {
        int n = this.find(string);
        if (n >= 0 && this.cards[n] instanceof RewardCard) {
            ((RewardCard)this.cards[n]).redeemPoints();
            return true;
        }
        return false;
    }

    public boolean pay(String string, double d) {
        int n = this.find(string);
        if (n >= 0) {
            this.cards[n].pay(d);
            return true;
        }
        return false;
    }

    public boolean issue(int n, String string, double d, char c) {
        boolean bl = false;
        CreditCard creditCard = c == 'R' ? new RewardCard(n, string, d) : new CreditCard(n, string, d);
        if (this.find(creditCard.getNumber()) == -1) {
            this.cards[this.size] = creditCard;
            ++this.size;
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "Global Credit Company [" + this.title + "]: CARDS=" + this.size + "/" + this.cards.length;
    }

    public CreditCard getFirst() {
        this.start = 0;
        return this.getNext();
    }

    public CreditCard getNext() {
        CreditCard creditCard = null;
        if (this.start < this.size) {
            creditCard = this.cards[this.start];
            ++this.start;
        }
        return creditCard;
    }

    private int find(String string) {
        int n = 0;
        while (n < this.size) {
            if (this.cards[n].getNumber().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

