/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import type.ec.Check;
import type.lang.IO;
import type.lang.UniReader;
import type.lang.UniWriter;
import type.uc.Terminal;
import type.uc.UniPanel;
import type.uc.eCheck;

public class UniCon
extends JFrame
implements ActionListener {
    private static final String VERSION = "B2";
    private static final String DIGITS = "0123456789";
    private static final String CAPS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    JSplitPane jsp;
    JMenuBar menuBar;
    JMenu menu;
    JMenuItem menuItem;
    Container cPane;
    JScrollPane scroll;
    String launchedFrom;
    String cookie = System.getProperty("user.home") + System.getProperty("file.separator");
    String userData;
    String[] data;
    JTextField login;
    JPasswordField pswrd;
    JTextField bfrSize;
    Terminal tv;
    JButton button;
    JDialog jd;
    int fontSize = 18;
    static final String HELP = "  ***************************************************************\n  |  Universal Console is a platform-neutral environment that   |\n  |  streamlines the compilation & execution of Java programs   |\n  |  on any platform. It is written in pure Java and features   |\n  |  a scrollable interactive [term] window that captures and   |\n  |  colour-codes standard in, out, and error.                  |\n  |                                                             |\n  |  - Colour Codes                                             |\n  |    blue=output, red=error, black=input, and green=command   |\n  |                                                             |\n  |   Note that you can use the arrow keys, PgUp/PgDn and/or    |\n  |   the mouse to move around, and you can select/copy text    |\n  |   to the clipboard as usual in your O/S.                    |\n  ***************************************************************\n";
    static final String COMMAND = "  ***************************************************************\n  |  - Commands                                                 |\n  |    > ls     lists contents of working directory (also dir)  |\n  |    > pwd    names the current working directory (also cd)   |\n  |    > cd x   change the working directory to x               |\n  |    > javac  compiles a java source file                     |\n  |    > java   runs an app (optionally passing arguments)      |\n  |    > clear  clears the entire console (also cls)            |\n  |    > ENTER  repeats the last-entered command                |\n  |                                                             |\n  |  - Keyboard Shortcuts                                       |\n  |    ^P=recompile, ^R=rerun, ^C=copy, ^I/^D=in/decrease size  |\n  ***************************************************************\n";
    static String ABOUT = "  ***************************************************************\n  |                                                             |\n  |        Designed and implemented by Prof. H. Roumani.        |\n  |        Toronto, Ontario, Canada; roumani@cs.yorku.ca        |\n  |        Trial Ver ^^/07-2002 - Eval License @@@@@@@@@        |\n  |                                                             |\n  ***************************************************************\n";

    public UniCon() {
        Object object;
        this.getCookie();
        long l = Long.parseLong(this.data[0].trim());
        int n = ABOUT.indexOf("@@@");
        ABOUT = ABOUT.substring(0, n) + IO.format(l, "9Z") + ABOUT.substring(n + 9);
        n = ABOUT.indexOf("^^");
        ABOUT = ABOUT.substring(0, n) + VERSION + ABOUT.substring(n + 2);
        if (l > 2000L && !new File("/cs/fac/bin/unicon").exists()) {
            System.out.println("This evaluation version has expired.");
            System.exit(-1);
        }
        if (l < 9999L) {
            ++l;
        }
        this.data[0] = "" + l;
        this.setCookie();
        this.login = new JTextField(this.data[1], 10);
        this.pswrd = new JPasswordField(this.data[2], 10);
        this.bfrSize = new JTextField(this.data[3], 10);
        this.launchedFrom = System.getProperty("java.home");
        this.setLAF(true, this);
        this.setTitle("Universal Console");
        this.setSize(1000, 600);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.tv = new Terminal("hamzeh");
        this.tv.setPreferredSize(this.getSize());
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        Hashtable<Object, Action> hashtable = new Hashtable<Object, Action>();
        Action[] actionArray = this.tv.getActions();
        int n2 = 0;
        while (n2 < actionArray.length) {
            object = actionArray[n2];
            hashtable.put(object.getValue("Name"), (Action)object);
            ++n2;
        }
        this.menu = new JMenu("File");
        this.menu.setMnemonic(70);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("Open Directory...", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Show Command Prompt", 80);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Exit", 88);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Edit");
        this.menu.setMnemonic(69);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("Clear Console", 76);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Copy", 67);
        this.menu.add(this.menuItem);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.menuItem.setAction((Action)hashtable.get("copy-to-clipboard"));
        this.menuItem = new JMenuItem("Select all", 83);
        this.menu.add(this.menuItem);
        this.menuItem.setAction((Action)hashtable.get("select-all"));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Increase Font Size", 73);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.menuItem = new JMenuItem("Decrease Font Size", 68);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Expand the Graphics Pane", 88);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setEnabled(false);
        this.menuItem = new JMenuItem("Collapse the Graphics Pane", 76);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Java L&F", 74);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("O/S L&F", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Tools");
        this.menu.setMnemonic(84);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("eCheck", 69);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("re-Compile", 80);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.menuItem = new JMenuItem("re-Run", 82);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("Options", 79);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu = new JMenu("Help");
        this.menu.setMnemonic(72);
        this.menuBar.add(this.menu);
        this.menuItem = new JMenuItem("Content", 67);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menuItem = new JMenuItem("Command List", 76);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.menu.addSeparator();
        this.menuItem = new JMenuItem("About", 65);
        this.menu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        this.tv.setBufferSize(this.data[3].trim());
        this.tv.setMargin(new Insets(10, 10, 10, 10));
        this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        this.tv.setBackground(Color.white);
        this.scroll = new JScrollPane(this.tv, 22, 32);
        this.cPane = this.getContentPane();
        this.tv.showCommand(IO.repeat(255, ' ') + "\n");
        object = new UniPanel();
        this.jsp = new JSplitPane(0, true, this.scroll, (Component)object);
        this.jsp.setDividerLocation(1.0);
        this.jsp.setOneTouchExpandable(true);
        this.cPane.add(this.scroll);
        this.tv.acceptCommand();
        this.cPane.requestFocusInWindow();
        this.scroll.requestFocusInWindow();
        this.tv.requestFocusInWindow();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.data[1] = this.login.getText();
            this.data[2] = new String(this.pswrd.getPassword());
            try {
                int n = Integer.parseInt(this.bfrSize.getText());
                if (n >= 0 && n < 10000) {
                    this.data[3] = IO.format(n, "4Z");
                    this.bfrSize.setText(this.data[3]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setCookie();
            this.tv.setBufferSize(this.data[3]);
            this.jd.dispose();
        }
        if (!(actionEvent.getSource() instanceof JMenuItem)) {
            return;
        }
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().indexOf("xit") != -1) {
            System.exit(-1);
        } else if (jMenuItem.getText().indexOf("eCheck") != -1) {
            this.eCheckAction();
        } else if (jMenuItem.getText().indexOf("Increase Font Size") != -1 && this.fontSize < 36) {
            ++this.fontSize;
            this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        } else if (jMenuItem.getText().indexOf("Decrease Font Size") != -1 && this.fontSize > 8) {
            --this.fontSize;
            this.tv.setFont(new Font("Monospaced", 0, this.fontSize));
        } else if (jMenuItem.getText().indexOf("Options") != -1) {
            this.optionAction();
        } else if (jMenuItem.getText().indexOf("Content") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(HELP);
            this.tv.acceptCommand();
        } else if (jMenuItem.getText().indexOf("Command List") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(COMMAND);
            this.tv.acceptCommand();
        } else if (jMenuItem.getText().indexOf("About") != -1) {
            this.tv.showCommand("\n");
            this.tv.showOutput(ABOUT);
            this.tv.acceptCommand();
        } else if (jMenuItem.getText().indexOf("Clear") != -1) {
            this.tv.clearAll();
            this.tv.acceptCommand();
        } else if (jMenuItem.getText().indexOf("Java L&F") != -1) {
            this.setLAF(false, this);
        } else if (jMenuItem.getText().indexOf("O/S L&F") != -1) {
            this.setLAF(true, this);
        } else if (jMenuItem.getText().indexOf("Open") != -1) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setDialogTitle("Select the Working Directory");
            int n = jFileChooser.showDialog(this, "Select");
            if (n == 0) {
                int n2;
                String string = jFileChooser.getSelectedFile().getPath();
                if (jFileChooser.getSelectedFile().isFile() && (n2 = string.lastIndexOf(File.separator)) != -1) {
                    string = string.substring(0, n2);
                }
                if (new File(string).exists()) {
                    this.tv.pwd = string;
                }
            }
        } else if (jMenuItem.getText().indexOf("Expand") != -1) {
            this.jsp.setDividerLocation(0.0);
        } else if (jMenuItem.getText().indexOf("Collapse") != -1) {
            this.jsp.setDividerLocation(1.0);
        } else if (jMenuItem.getText().indexOf("re-Compile") != -1) {
            this.tv.exec('C');
        } else if (jMenuItem.getText().indexOf("re-Run") != -1) {
            this.tv.exec('R');
        } else if (jMenuItem.getText().indexOf("Command Prompt") != -1) {
            this.tv.acceptCommand();
        }
    }

    public void optionAction() {
        this.jd = new JDialog(this, "Options", true);
        Container container = this.jd.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("Login ID: "));
        this.login.setForeground(Color.BLUE);
        container.add(this.login);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("Pawword: "));
        this.pswrd.setForeground(Color.BLUE);
        container.add(this.pswrd);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("Buffer Size: "));
        container.add(this.bfrSize);
        this.bfrSize.setEnabled(true);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("Remote Base: "));
        JTextField jTextField = new JTextField("http://www.cs.yorku.ca/~roumani/type", 50);
        jTextField.setFont(new Font("Monospaced", 0, 14));
        container.add(jTextField);
        jTextField.setEnabled(false);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("Local Base: "));
        JTextField jTextField2 = new JTextField(this.launchedFrom == null ? "null" : this.launchedFrom.toString(), 20);
        jTextField2.setFont(new Font("Monospaced", 0, 14));
        container.add(jTextField2);
        jTextField2.setEnabled(false);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        container.add(new JLabel("User Directory: "));
        JTextField jTextField3 = new JTextField(this.cookie, 20);
        jTextField3.setFont(new Font("Monospaced", 0, 14));
        container.add(jTextField3);
        jTextField3.setEnabled(false);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        this.button = new JButton("Apply");
        container.add(this.button);
        container.add(Box.createRigidArea(new Dimension(10, 20)));
        this.button.addActionListener(this);
        this.jd.pack();
        this.jd.setLocationRelativeTo(this);
        this.jd.show();
    }

    public void eCheckAction() {
        Check check;
        String string = "Enter the number of the Lab to be checked.\n A Lab number consists of up to two digits followed by a capital letter.";
        String string2 = JOptionPane.showInputDialog(this, string, "Lab Number", 3);
        if (string2 == null) {
            return;
        }
        if (string2.length() < 3) {
            string2 = "0" + string2;
        }
        if (!this.isValidLabNo(string2 = string2.toUpperCase())) {
            JOptionPane.showMessageDialog(this, "This is an invalid Lab number!", "Invalid Entry", 0);
            return;
        }
        if (!new File(this.tv.pwd + File.separator + "Check" + string2 + ".class").exists()) {
            JOptionPane.showMessageDialog(this, "The file: \"Check" + string2 + ".class\" " + "is not in the current directory.\n Use \"cd\" to switch to the " + "directory containing it then retry.", "File Not Found", 0);
            return;
        }
        IO.workingDir = this.tv.pwd;
        try {
            check = (Check)Class.forName("type.ec.Check" + string2).newInstance();
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "This is not a checkable Lab!", "Wrong Lab Number", 0);
            return;
        }
        eCheck eCheck2 = new eCheck("hamzeh", string2, this.tv, this.userData + VERSION, check);
        String string3 = eCheck2.send("1");
        boolean bl = string3.charAt(0) == '1';
        boolean bl2 = bl = bl || string3.substring(1, 5).equals("0000");
        if (!bl) {
            eCheck2.setCheckOnly(true);
            String string4 = "Please note that: \n";
            if (string3.charAt(2) == '1') {
                string4 = string4 + "- Your name is already checked off as having successfully completed this lab! \n";
            }
            if (string3.charAt(1) == '2') {
                string4 = string4 + "- No marks are associated with this lab. \n";
            }
            if (string3.charAt(1) == '1') {
                string4 = string4 + "- The deadline for submitting this lab has passed. \n";
            }
            if (string3.charAt(4) == '1') {
                string4 = string4 + "- Your login could not be authenticated! \n";
            }
            if (string3.charAt(3) == '1') {
                string4 = string4 + "- You are using an old version of UniCon. Download the newest one. \n";
            }
            boolean bl3 = bl = JOptionPane.showConfirmDialog(this, string4 = string4 + "Do you like to proceed (with checking only) anyway?", "Continue?", 0, 3) == 0;
        }
        if (bl) {
            eCheck2.start();
        }
    }

    private boolean isValidLabNo(String string) {
        boolean bl = false;
        if (string != null && string.length() == 3 && DIGITS.indexOf(string.charAt(0)) != -1 && DIGITS.indexOf(string.charAt(1)) != -1 && CAPS.indexOf(string.charAt(2)) != -1) {
            bl = true;
        }
        return bl;
    }

    private void getCookie() {
        this.data = new String[]{"0", "cs", "0", "9999"};
        if (new File(this.cookie + ".UCrc").exists()) {
            UniReader uniReader = new UniReader(this.cookie + ".UCrc");
            String string = uniReader.readLine();
            if ((string = IO.format(string, "2hamzeh3")).length() > 14) {
                this.data[0] = string.substring(0, 4);
                this.data[3] = string.substring(4, 8);
                int n = Integer.parseInt(string.substring(8, 10));
                this.data[1] = string.substring(12, 12 + n);
                int n2 = Integer.parseInt(string.substring(10, 12));
                this.data[2] = string.substring(12 + n, 12 + n + n2);
            }
            uniReader.close();
        }
    }

    private void setCookie() {
        this.userData = IO.format(this.data[1].length(), "2Z") + IO.format(this.data[2].length(), "2Z") + this.data[1] + this.data[2];
        UniWriter uniWriter = new UniWriter(this.cookie + ".UCrc");
        uniWriter.println(IO.format(IO.format(this.data[0].trim(), "4Z") + IO.format(this.data[3].trim(), "4Z") + this.userData, "2hamzeh2"));
        uniWriter.close();
    }

    public void setLAF(boolean bl, JFrame jFrame) {
        String string = UIManager.getCrossPlatformLookAndFeelClassName();
        if (bl) {
            string = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(jFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        UniCon uniCon = new UniCon();
        uniCon.show();
    }
}

