/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JTextPane;
import type.lang.IO;
import type.uc.TermCompile;
import type.uc.TermDoc;
import type.uc.TermErrStream;
import type.uc.TermInpStream;
import type.uc.TermOutStream;
import type.uc.TermRun;

public class Terminal
extends JTextPane {
    public String pwd;
    String entry;
    String lastCommand;
    TermRun runThread;
    TermOutStream tos;
    TermInpStream tis;
    TermErrStream tes;
    private TermDoc doc = (TermDoc)this.getDocument();
    private String lastCompile = null;
    private String lastRun = null;

    public Terminal(String string) {
        super(new TermDoc());
        if (!string.equals("hamzeh")) {
            System.exit(-1);
        }
        this.setCaretColor(Color.blue);
        this.doc.setTerminal(this);
        this.pwd = System.getProperty("user.home");
        this.lastCommand = null;
        this.entry = null;
        this.tis = new TermInpStream(this);
        this.tos = new TermOutStream(this);
        this.tes = new TermErrStream(this);
        System.setIn(this.tis);
        System.setOut(new PrintStream(this.tos, true));
        System.setErr(new PrintStream(this.tes, true));
        IO.format(null, "0hamzeh0");
        IO.format(null, "0hamzeh1");
    }

    public void setBufferSize(String string) {
        try {
            this.tos.setBufferSize(Long.parseLong(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void showOutput(String string) {
        this.doc.print(string, 2);
        Thread.currentThread();
        Thread.yield();
    }

    public void showCommand(String string) {
        this.doc.print(string, 3);
    }

    public void showError(String string) {
        this.doc.print(string, 4);
        TermRun.yield();
    }

    public void showErrorStream(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        this.doc.print(((Object)byteArrayOutputStream).toString(), 4);
    }

    public String read() {
        this.requestFocusInWindow();
        this.doc.setMode(1);
        this.entry = null;
        while (this.entry == null) {
            Thread.currentThread();
            Thread.yield();
        }
        String string = this.entry;
        this.entry = null;
        return string;
    }

    public void acceptCommand() {
        this.entry = "";
        this.doc.print("> ", 3);
        this.doc.setMode(0);
    }

    public void exec() {
        if (this.entry.trim().length() == 0 && this.lastCommand != null) {
            this.entry = this.lastCommand;
            this.showCommand("> " + this.entry + "\n");
        } else {
            this.lastCommand = this.entry.trim();
        }
        if (this.entry.indexOf("java") == 0) {
            this.doc.setMode(2);
            if (this.entry.indexOf("javac") == 0) {
                this.lastCompile = this.entry;
                new TermCompile(this.entry, this).start();
            } else if (this.entry.indexOf("java") == 0 && this.entry.trim().length() == 4) {
                this.lastCompile = this.entry;
                new TermCompile(this.entry, this).start();
            } else if (this.entry.indexOf("java") == 0 && this.entry.trim().length() > 5) {
                IO.workingDir = this.pwd;
                this.runThread = new TermRun(this.entry, this);
                this.lastRun = this.entry;
                this.runThread.start();
            }
            this.entry = null;
        } else {
            if (this.entry.indexOf("ls") == 0 || this.entry.indexOf("dir") == 0) {
                File[] fileArray = new File(this.pwd).listFiles();
                Object[] objectArray = new String[fileArray.length];
                int n = 0;
                while (n < fileArray.length) {
                    long l = fileArray[n].lastModified();
                    String string = IO.format(l, "25") + new Date(l).toString();
                    String string2 = fileArray[n].isDirectory() ? "<DIRECTORY>" : IO.format(fileArray[n].length(), ",10") + "B";
                    objectArray[n] = string + "   " + string2 + "   " + fileArray[n].getName();
                    ++n;
                }
                Arrays.sort(objectArray);
                this.showOutput("Content of directory: " + this.pwd + "\n");
                this.showOutput("--- LAST MODIFIED [DESC] ---  --- SIZE ---   --- NAME -------------------------\n");
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    this.showOutput(((String)objectArray[n2]).substring(25));
                    this.showOutput("\n");
                    --n2;
                }
                this.showOutput("--- LAST MODIFIED [DESC] ---  --- SIZE ---   --- NAME -------------------------\n");
                this.showCommand("listing completed.\n");
            } else if (this.entry.indexOf("pwd") == 0 || this.entry.indexOf("cd") == 0 && this.entry.trim().length() == 2) {
                this.showOutput("Working directory is: " + this.pwd + "\n");
                this.showCommand("pwd completed.\n");
            } else if (this.entry.indexOf("cls") == 0 || this.entry.indexOf("clear") == 0) {
                this.clearAll();
            } else if (this.entry.indexOf("cd") == 0 && this.entry.trim().length() > 2) {
                String string = this.entry.substring(2).trim();
                File file = new File(string);
                File file2 = new File(this.pwd + File.separator + string);
                File file3 = new File("c:" + string);
                if (file.isAbsolute() && file.exists()) {
                    this.pwd = file.getAbsolutePath();
                    this.showCommand("cd completed.\n");
                } else if (!file.isAbsolute() && file2.exists()) {
                    this.pwd = file2.getAbsolutePath();
                    this.showCommand("cd completed.\n");
                } else if (file3.exists()) {
                    this.pwd = file3.getAbsolutePath();
                    this.showCommand("cd completed.\n");
                } else {
                    this.showError("No such directory!\n");
                }
            } else if (this.entry.indexOf("hr") == 0) {
                this.showCommand("inp = " + System.in);
                this.showCommand("err = " + System.err);
                this.showCommand("out = " + System.out);
            } else {
                this.showError("Unrecognized command!\n");
            }
            this.acceptCommand();
        }
    }

    void exec(char c) {
        if (c == 'C' && this.lastCompile != null) {
            this.entry = this.lastCompile;
            this.showCommand(this.entry);
            this.exec();
        } else if (c == 'R' && this.lastRun != null) {
            this.entry = this.lastRun;
            this.showCommand(this.entry);
            this.exec();
        } else {
            this.showError("No previous compile/run were made!\n");
            this.acceptCommand();
        }
    }

    public void clearAll() {
        this.doc.setMode(-99);
        try {
            this.doc.remove(256, this.doc.getEndPosition().getOffset() - 257);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doc.setMode(0);
    }
}

