/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.io.OutputStream;
import type.uc.CheckProgramException;
import type.uc.Terminal;

class TermErrStream
extends OutputStream {
    Terminal term;
    StringBuffer buffer;
    boolean redirect;

    TermErrStream(Terminal terminal) {
        this.term = terminal;
        this.buffer = new StringBuffer("");
        this.redirect = false;
    }

    public void write(int n) {
        this.term.tos.realFlush();
        this.buffer.append((char)n);
    }

    public void flush() {
        String string = this.buffer.toString();
        this.buffer.delete(0, this.buffer.length());
        if (this.redirect) {
            this.revert();
            throw new CheckProgramException(string);
        }
        this.term.showError(string);
    }

    void inhibit() {
        this.redirect = true;
    }

    void revert() {
        this.redirect = false;
    }
}

