/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;
import type.lang.SE;

public class CreditCard
implements Serializable {
    public static final double DEFAULT_LIMIT = 1000.0;
    public static final int MIN_NAME_LENGTH = 3;
    public static final int SEQUENCE_NUMBER_LENGTH = 6;
    public static final int MOD = 9;
    private String number;
    private String name;
    private double limit;
    private double balance;

    public CreditCard(int n, String string, double d) {
        SE.require(string != null && string.length() >= 3, "Invalid Name");
        SE.require(d > 0.0, "Limit must be positive");
        SE.require(n > 0 && n <= 999999);
        this.name = string;
        this.limit = d;
        this.balance = 0.0;
        this.setCardNo(n);
        IO.format("CreditCard", "1hamzeh0");
    }

    public CreditCard(int n, String string) {
        this(n, string, 1000.0);
    }

    public double getBalance() {
        return this.balance;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public double getLimit() {
        return this.limit;
    }

    public boolean setLimit(double d) {
        boolean bl = false;
        if (d >= 0.0 && d > this.balance) {
            this.limit = d;
            bl = true;
        }
        return bl;
    }

    public void credit(double d) {
        SE.require(d >= 0.0, "Credit must be non-negative");
        this.balance -= d;
    }

    public boolean charge(double d) {
        SE.require(d >= 0.0, "Charge must be non-negative");
        if (this.balance + d <= this.limit) {
            this.balance += d;
            return true;
        }
        return false;
    }

    public void pay(double d) {
        SE.require(d >= 0.0, "Payment must be non-negative");
        this.balance -= d;
    }

    public boolean equals(Object object) {
        if (object instanceof CreditCard) {
            CreditCard creditCard = (CreditCard)object;
            return this.number == creditCard.number;
        }
        return false;
    }

    public String toString() {
        return "CARD [NO=" + this.number + ", BALANCE=" + IO.format(this.balance, ".2") + "]";
    }

    private void setCardNo(int n) {
        int n2 = CreditCard.digitSum(n);
        int n3 = 9 - n2 % 9;
        if (n3 == 9) {
            n3 = 0;
        }
        this.number = IO.format(n, "Z6") + "-" + n3;
    }

    private static int digitSum(int n) {
        String string = "" + Math.abs(n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            n2 += Integer.parseInt(string.substring(n3, n3 + 1));
            ++n3;
        }
        return n2;
    }
}

