/*
 * Decompiled with CFR 0.152.
 */
package type.uc;

import java.io.OutputStream;
import type.uc.Terminal;

class TermOutStream
extends OutputStream {
    Terminal term;
    StringBuffer buffer;
    long bufferSize;
    long bufferSizeCopy;
    boolean redirect;

    TermOutStream(Terminal terminal) {
        this.term = terminal;
        this.buffer = new StringBuffer("");
        this.bufferSize = 10000L;
        this.redirect = false;
    }

    public void write(int n) {
        this.buffer.append((char)n);
    }

    public void flush() {
        if ((long)this.buffer.length() > this.bufferSize) {
            this.realFlush();
        }
    }

    void realFlush() {
        if (this.buffer.length() != 0 && !this.redirect) {
            this.term.showOutput(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
        }
    }

    void setBufferSize(long l) {
        this.bufferSize = l;
    }

    void inhibit() {
        if (this.redirect) {
            return;
        }
        this.realFlush();
        this.bufferSizeCopy = this.bufferSize;
        this.bufferSize = 32000L;
        this.redirect = true;
    }

    String revert() {
        if (!this.redirect) {
            return null;
        }
        this.bufferSize = this.bufferSizeCopy;
        this.redirect = false;
        String string = this.buffer.toString();
        this.buffer.delete(0, this.buffer.length());
        return string;
    }
}

