/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import type.lang.IO;

public class UniWriter {
    private static final String EOL = System.getProperty("line.separator");
    private String descriptor;
    private String theTarget;
    private PrintWriter handle;

    public UniWriter(String string, boolean bl) {
        try {
            if (string == null) {
                this.handle = new PrintWriter(System.out);
                this.descriptor = "Standard Output";
            } else {
                if (!new File(string).isAbsolute()) {
                    string = IO.workingDir + File.separator + string;
                }
                this.handle = new PrintWriter(new FileOutputStream(string, bl));
                this.descriptor = "the file " + string;
            }
            this.theTarget = string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("File cannot be opened for writing!");
        }
    }

    public UniWriter(String string) {
        this(string, false);
    }

    public UniWriter() {
        this(null);
    }

    public String toString() {
        return "A UniWriter connected to " + this.descriptor;
    }

    public void close() {
        if (this.theTarget == null) {
            return;
        }
        this.handle.close();
    }

    public void println() {
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(char c) {
        this.handle.print("" + c);
        this.handle.flush();
    }

    public void println(char c) {
        this.print(c);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(long l) {
        this.handle.print("" + l);
        this.handle.flush();
    }

    public void println(long l) {
        this.print(l);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(double d) {
        this.handle.print("" + d);
        this.handle.flush();
    }

    public void println(double d) {
        this.print(d);
        this.print(EOL);
        this.handle.flush();
    }

    public void print(boolean bl) {
        if (bl) {
            this.handle.print("true");
            this.handle.flush();
        } else {
            this.handle.print("false");
            this.handle.flush();
        }
    }

    public void println(boolean bl) {
        this.print(bl);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(Object object) {
        if (object == null) {
            this.handle.print("<null>");
        } else {
            this.handle.print(object.toString());
        }
        this.handle.flush();
    }

    public void println(Object object) {
        this.print(object);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(byte by, String string) {
        this.handle.print(IO.format(by, string));
        this.handle.flush();
    }

    public void println(byte by, String string) {
        this.print(by, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(short s, String string) {
        this.handle.print(IO.format(s, string));
        this.handle.flush();
    }

    public void println(short s, String string) {
        this.print(s, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(char c, String string) {
        this.handle.print(IO.format(c, string));
        this.handle.flush();
    }

    public void println(char c, String string) {
        this.print(c, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(int n, String string) {
        this.handle.print(IO.format(n, string));
        this.handle.flush();
    }

    public void println(int n, String string) {
        this.print(n, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(long l, String string) {
        this.handle.print(IO.format(l, string));
        this.handle.flush();
    }

    public void println(long l, String string) {
        this.print(l, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(float f, String string) {
        this.handle.print(IO.format(f, string));
        this.handle.flush();
    }

    public void println(float f, String string) {
        this.print(f, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(double d, String string) {
        this.handle.print(IO.format(d, string));
        this.handle.flush();
    }

    public void println(double d, String string) {
        this.print(d, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(boolean bl, String string) {
        this.handle.print(IO.format(bl, string));
        this.handle.flush();
    }

    public void println(boolean bl, String string) {
        this.print(bl, string);
        this.handle.print(EOL);
        this.handle.flush();
    }

    public void print(Object object, String string) {
        this.handle.print(IO.format(object, string));
        this.handle.flush();
    }

    public void println(Object object, String string) {
        this.print(object, string);
        this.handle.print(EOL);
        this.handle.flush();
    }
}

