/*
 * Decompiled with CFR 0.152.
 */
package type.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import type.lang.IO;

public class UniReader {
    private String descriptor;
    private String theSource;
    private BufferedReader handle;
    private boolean eofState;
    private String myBuffer;

    public UniReader(String string) {
        try {
            if (string == null) {
                this.handle = new BufferedReader(new InputStreamReader(System.in));
                this.descriptor = "Standard Input";
            } else if (string.indexOf("http://") == 0) {
                this.handle = new BufferedReader(new InputStreamReader(new URL(string).openStream()));
                this.descriptor = "the URL " + string;
            } else {
                if (!new File(string).isAbsolute()) {
                    string = IO.workingDir + File.separator + string;
                }
                this.handle = new BufferedReader(new FileReader(string));
                this.descriptor = "the file " + string;
            }
            this.theSource = string;
            this.eofState = false;
            this.myBuffer = "";
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File/Path not found!");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid URL!");
        }
        catch (IOException iOException) {
            throw new RuntimeException("File cannot be opened for reading!");
        }
    }

    public UniReader() {
        this(null);
    }

    public String toString() {
        return "A UniReader connected to: " + this.theSource;
    }

    public boolean eof() {
        return this.eofState;
    }

    public void close() {
        if (this.theSource == null) {
            return;
        }
        try {
            this.handle.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("File cannot be closed!");
        }
    }

    public char readChar() {
        char c = '\u0000';
        if (this.myBuffer.length() != 0) {
            c = this.myBuffer.charAt(0);
            this.myBuffer = "";
        } else if (this.eofState) {
            throw new RuntimeException("Reading past end-of-file!");
        }
        try {
            int n = this.handle.read();
            if (n == -1) {
                this.eofState = true;
            } else {
                c = (char)n;
                if (c == '\r') {
                    c = (char)this.handle.read();
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Reading error!");
        }
        return c;
    }

    public String readWord() {
        String string;
        char c = this.readChar();
        while (Character.isWhitespace(c) && !this.eofState) {
            c = this.readChar();
        }
        if (this.eofState) {
            string = null;
        } else {
            string = "";
            while (!Character.isWhitespace(c) && !this.eofState) {
                string = string + c;
                c = this.readChar();
            }
            if (!this.eofState) {
                this.myBuffer = "" + c;
            }
            this.eofState = false;
        }
        return string;
    }

    public byte readByte() {
        String string = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Byte.valueOf(string);
    }

    public short readShort() {
        String string = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Short.valueOf(string);
    }

    public int readInt() {
        String string = this.readWord();
        if (this.eofState) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public long readLong() {
        String string = this.readWord();
        if (this.eofState) {
            return 0L;
        }
        return Long.valueOf(string);
    }

    public float readFloat() {
        String string = this.readWord();
        if (this.eofState) {
            return 0.0f;
        }
        return Float.valueOf(string).floatValue();
    }

    public double readDouble() {
        String string = this.readWord();
        if (this.eofState) {
            return 0.0;
        }
        return Double.valueOf(string);
    }

    public boolean readBoolean() {
        String string = this.readWord();
        if (this.eofState) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public String readLine() {
        String string = "";
        char c = this.readChar();
        while (c != '\n' && !this.eofState) {
            string = string + c;
            c = this.readChar();
        }
        if (this.eofState) {
            if (string.length() == 0) {
                string = null;
            } else {
                this.eofState = false;
            }
        } else {
            this.myBuffer = "" + c;
        }
        return string;
    }
}

