/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import type.lang.IO;

public class Item
implements Serializable,
Comparable {
    private String number;
    private String name;
    private double uPrice;
    private int soldQty = 0;
    private double sales = 0.0;
    private int purchasedQty = 0;
    private double purchases = 0.0;

    public Item(String string, String string2, double d) {
        this.name = string2;
        this.number = string;
        this.uPrice = d;
        IO.crash(string2 != null, "Item's name cannot be null!");
        IO.crash(string != null, "Item's number cannot be null!");
        IO.crash(d >= 0.0, "Item's price cannot be negative");
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getStock() {
        return this.purchasedQty - this.soldQty;
    }

    public double getUnitCost() {
        return this.purchases / (double)this.purchasedQty;
    }

    public boolean setUnitPrice(double d) {
        if (d >= 0.0) {
            this.uPrice = d;
            return true;
        }
        return false;
    }

    public double getUnitPrice() {
        return this.uPrice;
    }

    public int getSoldQty() {
        return this.soldQty;
    }

    public double getSales() {
        return this.sales;
    }

    public int getPurchasedQty() {
        return this.purchasedQty;
    }

    public double getPurchases() {
        return this.purchases;
    }

    public boolean sell(int n) {
        return this.sell(n, (double)n * this.getUnitPrice());
    }

    public boolean sell(int n, double d) {
        if (n > this.purchasedQty - this.soldQty) {
            return false;
        }
        this.soldQty += n;
        this.sales += d;
        return true;
    }

    public void purchase(int n, double d) {
        this.purchasedQty += n;
        this.purchases += d;
    }

    public String toString() {
        return "Item# " + this.number + " " + this.name;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Item && ((Item)object).getNumber().equals(this.number);
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }
}

