/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;

public class FractionNS
implements Serializable,
Comparable {
    private long numer;
    private long denom;
    public char separator = (char)47;
    public static boolean isQuoted = true;
    protected static Random rng = new Random();

    public FractionNS() {
        this(0L, 1L);
    }

    public FractionNS(long l, long l2) {
        IO.format("FractionNS", "1hamzeh0");
        this.setState(l, l2);
    }

    public void add(FractionNS fractionNS) {
        if (this.denom == 0L || fractionNS.getDenominator() == 0L) {
            this.numer = this.numer * fractionNS.getDenominator() + fractionNS.getNumerator() * this.denom;
            this.denom *= fractionNS.getDenominator();
        } else {
            long l = FractionNS.lcm(this.denom, fractionNS.getDenominator());
            this.numer = this.numer * (l / this.denom) + fractionNS.getNumerator() * (l / fractionNS.getDenominator());
            this.denom = l;
            this.reduce();
        }
    }

    public void subtract(FractionNS fractionNS) {
        FractionNS fractionNS2 = new FractionNS(-fractionNS.getNumerator(), fractionNS.getDenominator());
        this.add(fractionNS2);
    }

    public void multiply(FractionNS fractionNS) {
        this.numer *= fractionNS.numer;
        this.denom *= fractionNS.denom;
        this.reduce();
    }

    public void divide(FractionNS fractionNS) {
        FractionNS fractionNS2 = new FractionNS(fractionNS.denom, fractionNS.numer);
        this.multiply(fractionNS2);
    }

    public void pow(int n) {
        IO.crash(n >= 0, "A negative exponent!");
        if (n > 1) {
            boolean bl = n / 2 * 2 == n;
            FractionNS fractionNS = new FractionNS(this.getNumerator(), this.getDenominator());
            this.pow(n / 2);
            FractionNS fractionNS2 = new FractionNS(this.getNumerator(), this.getDenominator());
            this.multiply(fractionNS2);
            if (!bl) {
                this.multiply(fractionNS);
            }
        } else if (n == 0) {
            this.numer = 1L;
            this.denom = 1L;
        }
    }

    public void setNumerator(long l) {
        this.setState(l, this.denom);
    }

    public long getNumerator() {
        return this.numer;
    }

    public void setDenominator(long l) {
        this.setState(this.numer, l);
    }

    public long getDenominator() {
        return this.denom;
    }

    public void setFraction(long l, long l2) {
        this.setState(l, l2);
    }

    public void setFraction(FractionNS fractionNS) {
        this.setState(fractionNS.numer, fractionNS.denom);
    }

    public boolean setSeparator(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        this.separator = c;
        return true;
    }

    public char getSeaparator() {
        return this.separator;
    }

    public String toProperString() {
        String string = "";
        if (isQuoted) {
            string = "\"";
        }
        if (this.denom == 0L) {
            return "NaF";
        }
        if (Math.abs(this.numer) < this.denom) {
            return string + this.numer + "/" + this.denom + string;
        }
        long l = this.numer / this.denom;
        return string + l + " " + this.numer % this.denom + "/" + this.denom + string;
    }

    public boolean resembles(FractionNS fractionNS) {
        if (fractionNS == null) {
            return false;
        }
        return this.getDenominator() == fractionNS.getDenominator();
    }

    public static FractionNS getRandom() {
        return new FractionNS(rng.nextInt(1000), 1 + rng.nextInt(1000));
    }

    public static void setSeed(long l) {
        rng.setSeed(l);
    }

    public FractionNS cloneMe() {
        FractionNS fractionNS = new FractionNS(this.numer, this.denom);
        return fractionNS;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FractionNS)) {
            throw new ClassCastException();
        }
        FractionNS fractionNS = (FractionNS)object;
        if (this.denom == 0L) {
            if (fractionNS.denom == 0L) {
                return 0;
            }
            return 1;
        }
        if (fractionNS.denom == 0L) {
            if (this.denom == 0L) {
                return 0;
            }
            return -1;
        }
        long l = this.numer * fractionNS.denom - this.denom * fractionNS.numer;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    private void setState(long l, long l2) {
        if (l2 < 0L) {
            this.numer = -l;
            this.denom = -l2;
        } else {
            this.numer = l;
            this.denom = l2;
        }
        IO.crash(this.denom >= 0L, "Internal Error in setState: " + this.denom);
        this.reduce();
    }

    private void reduce() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l == 0L || l2 == 0L) {
            return;
        }
        long l3 = FractionNS.euc(l, l2);
        this.numer /= l3;
        this.denom /= l3;
    }

    private static long lcm(long l, long l2) {
        return l * l2 / FractionNS.euc(l, l2);
    }

    private static long euc(long l, long l2) {
        long l3;
        if (l == 0L || l2 == 0L) {
            return 1L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l < l2) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }
}

