/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.CreditCard;

public class RewardCard
extends CreditCard {
    public static final double DEFAULT_LIMIT = 5000.0;
    public static final int REWARD_RATE = 20;
    private int points = 0;

    public RewardCard(int n, String string, double d) {
        super(n, string, d);
        IO.format("RewardCard", "1hamzeh0");
    }

    public RewardCard(int n, String string) {
        super(n, string, 5000.0);
        IO.format("RewardCard", "1hamzeh0");
    }

    public int getPointBalance() {
        return this.points;
    }

    @Override
    public boolean charge(double d) {
        if (super.charge(d)) {
            this.points = (int)((double)this.points + Math.floor(d / 20.0));
            return true;
        }
        return false;
    }

    @Override
    public void credit(double d) {
        super.credit(d);
        this.points = (int)((double)this.points - Math.floor(d / 20.0));
    }

    public void redeem(int n) {
        IO.crash(n >= 0, "Negative number of points!");
        IO.crash(n <= this.points, "Number of points exceed point balance!");
        this.points -= n;
    }

    @Override
    public String toString() {
        String string = super.toString();
        return "RWRD" + string.substring(4, string.length() - 1) + ", POINTS=" + this.points + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof RewardCard) {
            return super.equals(object);
        }
        return false;
    }

    public boolean isSimilar(RewardCard rewardCard) {
        if (rewardCard == null) {
            return false;
        }
        return super.isSimilar(rewardCard) && this.points == rewardCard.points;
    }
}

