/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import type.lang.IO;
import type.lib.Fraction;
import type.lib.MixedNumber;

public class Money
extends MixedNumber {
    public Money() {
        this(1, 1L, 0L);
    }

    public Money(double d) {
        this(Money.signOf(d), Money.dollarOf(d), Money.centOf(d));
    }

    public Money(int n, long l, long l2) {
        super(n, l + l2 / 100L, l2 % 100L, 100L);
    }

    public long getDollar() {
        return super.getWhole();
    }

    public long getCent() {
        return this.getProperNumerator() * 100L / super.getProperDenominator();
    }

    @Override
    public String toString() {
        if (super.getProperDenominator() == 0L) {
            return "NaM";
        }
        String string = "";
        if (this.getSign() == -1) {
            string = "(minus) ";
        }
        return string + "$" + IO.format(this.getDollar(), ",") + " dollars and " + this.getCent() + " cents.";
    }

    private static int signOf(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    private static long dollarOf(double d) {
        String string = IO.format(d, ".2");
        int n = string.indexOf(".");
        return Math.abs(Long.parseLong(string.substring(0, n)));
    }

    private static long centOf(double d) {
        String string = IO.format(d, ".2");
        int n = string.indexOf(".");
        return Long.parseLong(string.substring(n + 1, n + 3));
    }

    public boolean resembles(Money money) {
        if (money == null) {
            return false;
        }
        return this.getCent() / 25L == money.getCent() / 25L;
    }

    public static Fraction getRandom() {
        if (rng.nextInt(2) == 0) {
            return new Money(1000.0 + rng.nextDouble() * 2000.0);
        }
        return MixedNumber.getRandom();
    }
}

