/*
 * Decompiled with CFR 0.152.
 */
package type.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import type.lang.IO;

public class Formatter {
    private boolean separator;
    private int width;
    private int decimals;
    private String pattern = "";

    public String format(String string, int n) {
        this.convertMe(string);
        String string2 = this.separator ? new DecimalFormat("#,###").format(n) : "" + n;
        return this.size(string2);
    }

    public String format(String string, double d) {
        this.convertMe(string);
        if (this.decimals == -1) {
            this.decimals = 6;
        }
        boolean bl = d - Math.rint(d) != 0.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        BigDecimal bigDecimal2 = bigDecimal.setScale(this.decimals, 4);
        d = bigDecimal2.doubleValue();
        String string2 = this.decimals == 0 ? ".#" : "." + IO.repeat(this.decimals, '0');
        string2 = this.separator ? "#,##0" + string2 : "0" + string2;
        String string3 = new DecimalFormat(string2).format(d);
        if (bl && this.decimals == 0) {
            string3 = string3 + ".";
        }
        return this.size(string3);
    }

    private void convertMe(String string) {
        String string2 = "";
        IO.crash(string.length() > 1, "Zero-length Format!");
        if (string.charAt(0) != '%') {
            throw new RuntimeException("% prefix missing!");
        }
        if ((string = string.substring(1)).charAt(0) == ',') {
            string = string.substring(1);
            string2 = ",";
        } else if (string.charAt(0) == '0') {
            string = string.substring(1);
            string2 = "Z";
        }
        int n = string.length();
        if ("df".indexOf(string.charAt(n - 1)) == -1) {
            throw new RuntimeException("Invalid conversion!");
        }
        string2 = string2 + string.substring(0, n - 1);
        this.extractAttributes(string2);
    }

    private void extractAttributes(String string) {
        this.separator = false;
        this.width = -1;
        this.decimals = -1;
        int n = string.indexOf(44, 0);
        if (n > -1) {
            this.separator = true;
            string = string.substring(0, n) + string.substring(n + 1);
        }
        if ((n = string.indexOf(46, 0)) > -1) {
            this.decimals = Integer.parseInt(string.substring(n + 1));
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            this.width = Integer.parseInt(string);
        }
    }

    private String size(String string) {
        int n = this.width - string.length();
        return IO.repeat(n, ' ') + string;
    }
}

