/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;

public class Fraction
implements Serializable,
Comparable {
    private long numer;
    private long denom;
    public char separator = (char)47;
    public static boolean isQuoted = true;
    protected static Random rng = new Random();

    public Fraction() {
        this(0L, 1L);
    }

    public Fraction(long l, long l2) {
        IO.format("Fraction", "1hamzeh0");
        this.setState(l, l2);
    }

    public void add(Fraction fraction) {
        if (this.denom == 0L || fraction.getDenominator() == 0L) {
            this.numer = this.numer * fraction.getDenominator() + fraction.getNumerator() * this.denom;
            this.denom *= fraction.getDenominator();
        } else {
            long l = Fraction.lcm(this.denom, fraction.getDenominator());
            this.numer = this.numer * (l / this.denom) + fraction.getNumerator() * (l / fraction.getDenominator());
            this.denom = l;
            this.reduce();
        }
    }

    public void subtract(Fraction fraction) {
        Fraction fraction2 = new Fraction(-fraction.getNumerator(), fraction.getDenominator());
        this.add(fraction2);
    }

    public void multiply(Fraction fraction) {
        this.numer *= fraction.numer;
        this.denom *= fraction.denom;
        this.reduce();
    }

    public void divide(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction.denom, fraction.numer);
        this.multiply(fraction2);
    }

    public void pow(int n) {
        IO.crash(n >= 0, "A negative exponent!");
        if (n > 1) {
            boolean bl = n / 2 * 2 == n;
            Fraction fraction = new Fraction(this.getNumerator(), this.getDenominator());
            this.pow(n / 2);
            Fraction fraction2 = new Fraction(this.getNumerator(), this.getDenominator());
            this.multiply(fraction2);
            if (!bl) {
                this.multiply(fraction);
            }
        } else if (n == 0) {
            this.numer = 1L;
            this.denom = 1L;
        }
    }

    public void setNumerator(long l) {
        this.setState(l, this.denom);
    }

    public long getNumerator() {
        return this.numer;
    }

    public void setDenominator(long l) {
        this.setState(this.numer, l);
    }

    public long getDenominator() {
        return this.denom;
    }

    public void setFraction(long l, long l2) {
        this.setState(l, l2);
    }

    public void setFraction(Fraction fraction) {
        this.setState(fraction.numer, fraction.denom);
    }

    public boolean setSeparator(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        this.separator = c;
        return true;
    }

    public char getSeaparator() {
        return this.separator;
    }

    public String toString() {
        if (this.denom == 0L) {
            return "NaF";
        }
        return "" + this.numer + this.separator + this.denom;
    }

    public String toProperString() {
        String string = "";
        if (isQuoted) {
            string = "\"";
        }
        if (this.denom == 0L) {
            return "NaF";
        }
        long l = this.numer / this.denom;
        if (this.numer == 0L || this.numer % this.denom == 0L) {
            return string + l + string;
        }
        if (Math.abs(this.numer) < this.denom) {
            return string + this.numer + "/" + this.denom + string;
        }
        return string + l + " " + this.numer % this.denom + "/" + this.denom + string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)object;
        return this.getNumerator() * fraction.getDenominator() == this.getDenominator() * fraction.getNumerator();
    }

    public int hashCode() {
        Double d = new Double((double)this.numer / (double)this.denom);
        return d.hashCode();
    }

    public boolean resembles(Fraction fraction) {
        if (fraction == null) {
            return false;
        }
        return this.getDenominator() == fraction.getDenominator();
    }

    public static Fraction getRandom() {
        return new Fraction(rng.nextInt(1000), 1 + rng.nextInt(1000));
    }

    public static void setSeed(long l) {
        rng.setSeed(l);
    }

    public Fraction cloneMe() {
        Fraction fraction = new Fraction(this.numer, this.denom);
        return fraction;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Fraction)) {
            throw new ClassCastException();
        }
        Fraction fraction = (Fraction)object;
        if (this.denom == 0L) {
            if (fraction.denom == 0L) {
                return 0;
            }
            return 1;
        }
        if (fraction.denom == 0L) {
            if (this.denom == 0L) {
                return 0;
            }
            return -1;
        }
        long l = this.numer * fraction.denom - this.denom * fraction.numer;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    private void setState(long l, long l2) {
        if (l2 < 0L) {
            this.numer = -l;
            this.denom = -l2;
        } else {
            this.numer = l;
            this.denom = l2;
        }
        IO.crash(this.denom >= 0L, "Internal Error in setState: " + this.denom);
        this.reduce();
    }

    private void reduce() {
        long l = this.getNumerator();
        long l2 = this.getDenominator();
        if (l == 0L || l2 == 0L) {
            return;
        }
        long l3 = Fraction.euc(l, l2);
        this.numer /= l3;
        this.denom /= l3;
    }

    private static long lcm(long l, long l2) {
        return l * l2 / Fraction.euc(l, l2);
    }

    private static long euc(long l, long l2) {
        long l3;
        if (l == 0L || l2 == 0L) {
            return 1L;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l < l2) {
            l3 = l2;
            l2 = l;
            l = l3;
        }
        l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }
}

