/*
 * Decompiled with CFR 0.152.
 */
package type.lib;

import java.io.Serializable;
import java.util.Random;
import type.lang.IO;
import type.lib.Stock;

public class Investment
implements Serializable {
    private Stock stock;
    private int qty;
    private double bookValue;
    private static Random rng = new Random();

    public Investment(Stock stock, int n, double d) {
        this.stock = stock;
        this.setQty(n);
        this.setBookValue(d);
        IO.format("Investment", "1hamzeh0");
    }

    public Stock getStock() {
        return this.stock;
    }

    public int getQty() {
        return this.qty;
    }

    public void setQty(int n) {
        this.qty = n;
    }

    public double getBookValue() {
        return this.bookValue;
    }

    public void setBookValue(double d) {
        this.bookValue = d;
    }

    public String toString() {
        String string = "null";
        if (this.stock != null) {
            string = this.stock.toString();
        }
        return string + " QTY=" + this.qty + " BV=" + this.bookValue;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Investment)) {
            return false;
        }
        Investment investment = (Investment)object;
        boolean bl = investment.stock == this.stock || investment.stock != null && investment.getStock().equals(this.stock);
        bl = bl && Math.abs(investment.getBookValue() - this.bookValue) < 0.01;
        return bl;
    }

    public Investment cloneMe() {
        if (this.stock == null) {
            return new Investment(null, this.qty, this.bookValue);
        }
        return new Investment(this.stock.cloneMe(), this.qty, this.bookValue);
    }

    public static Investment getRandom() {
        char c = (char)(65 + rng.nextInt(26));
        char c2 = (char)(65 + rng.nextInt(26));
        Stock stock = new Stock("." + c + c2);
        return new Investment(stock, 1 + rng.nextInt(5000), (rng.nextGaussian() / 50.0 + 1.0) * stock.getPrice());
    }
}

